<?php
function logitic_button_style_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_button_setting' , array(
        'title'      => esc_html__( 'Button Settings', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	//Start Background Color
    $logitic_customizer->add_setting(
        'logitic_button_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_button_bg_color',
            array(
                'label' => esc_html__('Button Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_button_setting',
                'settings' => 'logitic_button_bg_color',
            )
        )
    );
    //End Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'button_style_hr_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'button_style_hr_0', 
			array(
				'settings'		=> 'button_style_hr_0',
				'section'  		=> 'logitic_button_setting',
			)
		)
	);
	//End separator

	//Start Background Color
    $logitic_customizer->add_setting(
        'logitic_button_bg_hover_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_button_bg_hover_color',
            array(
                'label' => esc_html__('Button Hover Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_button_setting',
                'settings' => 'logitic_button_bg_hover_color',
            )
        )
    );
    //End Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'button_style_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'button_style_hr_1', 
			array(
				'settings'		=> 'button_style_hr_1',
				'section'  		=> 'logitic_button_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_button_text_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_button_text_color',
            array(
                'label' => esc_html__('Button Text Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_button_setting',
                'settings' => 'logitic_button_text_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'button_style_hr_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'button_style_hr_2', 
			array(
				'settings'		=> 'button_style_hr_2',
				'section'  		=> 'logitic_button_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_button_hover_text_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_button_hover_text_color',
            array(
                'label' => esc_html__('Button Text Hover Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_button_setting',
                'settings' => 'logitic_button_hover_text_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'button_style_hr_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'button_style_hr_3', 
			array(
				'settings'		=> 'button_style_hr_3',
				'section'  		=> 'logitic_button_setting',
			)
		)
	);
	//End separator

	//Start container size
    $logitic_customizer->add_setting(
        'logitic_button_border_radius',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_button_border_radius', array(
        'section' => 'logitic_button_setting',
        'label' => esc_html__('Button Border Radius', 'logitic'),
        'description' => esc_html__('Border Radius example(5px)', 'logitic'),
        'type' => 'text',
        'setting' => 'logitic_button_border_radius',
    ));
    //End container size
}