<?php
function logitic_offcanvas_style_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_offcanvas_setting' , array(
        'title'      => esc_html__( 'Offcanvas Settings', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	//Start enabal
    $logitic_customizer->add_setting('logitic_enable_offcanvas',
		array(
			'default' => 0
		)
    );
    $logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_enable_offcanvas',
			array(
				'type' => 'switch',
				'label' => esc_html__('Show OFF Canvas', 'logitic'),
				'description' => esc_html__('You can show or hide offcanvas', 'logitic'),
				'section' => 'logitic_offcanvas_setting',
			)
		)
    );
    //End enabal

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_00', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_00', 
			array(
				'settings'		=> 'offcanvas_hr_00',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start default header logo
	$logitic_customizer->add_setting(
		'logitic_offcanvas_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_offcanvas_logo',
			array(
			'label'      => esc_html__( 'Offcanvas Logo', 'logitic' ),
			'section'    => 'logitic_offcanvas_setting',
			'settings'   => 'logitic_offcanvas_logo',
			)
		)   
	);
	//End default logo

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_0', 
			array(
				'settings'		=> 'offcanvas_hr_0',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start container size
    $logitic_customizer->add_setting(
        'logitic_offcanvas_logo_height',
        array(
			'default'   => '50px',
            'transport' => 'refresh',
        )
    );

    $logitic_customizer->add_control('logitic_offcanvas_logo_height', array(
        'section'     => 'logitic_offcanvas_setting',
        'label'       => esc_html__('Logo Height', 'logitic'),
        'description' => esc_html__('Logo max height example(50px)', 'logitic'),
        'type'        => 'text',
        'setting'     => 'logitic_offcanvas_logo_height',
    ));
    //End container size

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_1', 
			array(
				'settings'		=> 'offcanvas_hr_1',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Email Address
    $logitic_customizer->add_setting(
        'logitic_offcanvas_email_address',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_offcanvas_email_address', array(
        'section'     => 'logitic_offcanvas_setting',
        'label'       => esc_html__('Email Address', 'logitic'),
        'description' => esc_html__('Offcanvas email address', 'logitic'),
        'type'        => 'text',
        'setting'     => 'logitic_offcanvas_email_address',
    ));
    //End Email Address

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_email', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_email', 
			array(
				'settings'		=> 'offcanvas_hr_email',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Phone Number
    $logitic_customizer->add_setting(
        'logitic_offcanvas_phone_number',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_offcanvas_phone_number', array(
        'section'     => 'logitic_offcanvas_setting',
        'label'       => esc_html__('Phone Number', 'logitic'),
        'description' => esc_html__('Offcanvas phone number', 'logitic'),
        'type'        => 'text',
        'setting'     => 'logitic_offcanvas_phone_number',
    ));
    //End Phone Number

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_phone', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_phone', 
			array(
				'settings'		=> 'offcanvas_hr_phone',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Address
	$logitic_customizer->add_setting('logitic_offcanvas_address', array(
		'transport'		=> 'refresh',
	));
	$logitic_customizer->add_control('logitic_offcanvas_address', array(
		'section'	    => 'logitic_offcanvas_setting',
		'label'			=> esc_html__( 'Address', 'logitic' ),
		'description'	=> esc_html__('Offcanvas address', 'logitic'),
		'type'		    => 'textarea',
		'setting'	    => 'logitic_offcanvas_address'	
	));
	//End Address

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_address', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_address', 
			array(
				'settings'		=> 'offcanvas_hr_address',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_bg_color',
            array(
                'label'       => esc_html__('Background Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_bg_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_3', 
			array(
				'settings'		=> 'offcanvas_hr_3',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_text_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_text_color',
            array(
                'label'       => esc_html__('Text Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_text_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_2', 
			array(
				'settings'		=> 'offcanvas_hr_2',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_social_icon_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_social_icon_color',
            array(
                'label'       => esc_html__('Social Icon Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_social_icon_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_4', 
			array(
				'settings'		=> 'offcanvas_hr_4',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
	$logitic_customizer->add_setting(
		'logitic_offcanvas_button_color'
	);
	$logitic_customizer->add_control(
		new WP_Customize_Color_Control(
			$logitic_customizer,
			'logitic_offcanvas_button_color',
			array(
				'label'       => esc_html__('Social Button Color', 'logitic'),
				'description' => esc_html__('Pick color', 'logitic'),
				'section'     => 'logitic_offcanvas_setting',
				'settings'    => 'logitic_offcanvas_button_color',
			)
		)
	);
	//End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_5', 
			array(
				'settings'		=> 'offcanvas_hr_5',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_button_hover_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_button_hover_color',
            array(
                'label'       => esc_html__('Button hover Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_button_hover_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_6', 
			array(
				'settings'		=> 'offcanvas_hr_6',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_hamburger_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_hamburger_bg_color',
            array(
                'label'       => esc_html__('Hamburger Background Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_hamburger_bg_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_7', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_7', 
			array(
				'settings'		=> 'offcanvas_hr_7',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_hamburger_icon_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_hamburger_icon_color',
            array(
                'label'       => esc_html__('Hamburger Icon Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_hamburger_icon_color',
            )
        )
    );
    //End Body Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'offcanvas_hr_8', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'offcanvas_hr_8', 
			array(
				'settings'		=> 'offcanvas_hr_8',
				'section'  		=> 'logitic_offcanvas_setting',
			)
		)
	);
	//End separator

	//Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_offcanvas_hamburger_clode_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_offcanvas_hamburger_clode_color',
            array(
                'label'       => esc_html__('Hamburger Close Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section'     => 'logitic_offcanvas_setting',
                'settings'    => 'logitic_offcanvas_hamburger_clode_color',
            )
        )
    );
    //End Body Background Color
}