<?php
function logitic_typography_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_typography_setting' , array(
        'title'      => esc_html__( 'Typography Settings', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	$rs_custom_fonts = get_terms([
		'taxonomy'   => 'rs_custom_fonts',
		'hide_empty' => false,
	]);


	$rs_custom_font_key = [];
	$rs_custom_font_val = [];
	if( is_array( $rs_custom_fonts ) ){
		foreach( $rs_custom_fonts as $rs_custom_font ){
			array_push( $rs_custom_font_key, $rs_custom_font->name );
			array_push( $rs_custom_font_val, $rs_custom_font->name );
		}
	}

	
	$font_choices_custom = array_combine( array_map(function($el) use ($rs_custom_font_val) {
		return $rs_custom_font_val[$el];
	}, array_keys($rs_custom_font_key)), array_values($rs_custom_font_key));


	if( is_array( $rs_custom_fonts ) && !empty( $rs_custom_fonts ) ){
		array_unshift( $font_choices_custom, esc_html__( 'Custom Font', 'logitic') );
	}
	

	$font_choices_google = [
		'google'              => esc_html__( 'Google Fonts', 'logitic'),
		'Space Grotesk'       => esc_html__( 'Space Grotesk', 'logitic'),
		'Open Sans'           => esc_html__( 'Open Sans', 'logitic'),
		'Oswald'              => esc_html__( 'Oswald', 'logitic'),
		'Playfair Display'    => esc_html__( 'Playfair Display', 'logitic'),
		'Montserrat'          => esc_html__( 'Montserrat', 'logitic'),
		'Nunito Sans'         => esc_html__( 'Nunito Sans', 'logitic'),
		'Inter'               => esc_html__( 'Inter', 'logitic'),
		'Rajdhani'            => esc_html__( 'Rajdhani', 'logitic'),
		'Comfortaa'           => esc_html__( 'Comfortaa', 'logitic'),
		'Raleway'             => esc_html__( 'Raleway', 'logitic'),
		'Droid Sans'          => esc_html__( 'Droid Sans', 'logitic'),
		'Lato'                => esc_html__( 'Lato', 'logitic'),
		'Arvo'                => esc_html__( 'Arvo', 'logitic'),
		'Lora'                => esc_html__( 'Lora', 'logitic'),
		'Poppins'             => esc_html__( 'Poppins', 'logitic'),
		'Merriweather'        => esc_html__( 'Merriweather', 'logitic'),
		'Oxygen'              => esc_html__( 'Oxygen', 'logitic'),
		'PT Serif'            => esc_html__( 'PT Serif', 'logitic'),
		'PT Sans'             => esc_html__( 'PT Sans', 'logitic'),
		'PT Sans Narrow'      => esc_html__( 'PT Sans Narrow', 'logitic'),
		'Public Sans'         => esc_html__( 'Public Sans', 'logitic'),
		'Cabin'               => esc_html__( 'Cabin', 'logitic'),
		'Fjalla One'          => esc_html__( 'Fjalla One', 'logitic'),
		'Francois One'        => esc_html__( 'Francois One', 'logitic'),
		'Rubik'        		  => esc_html__( 'Rubik', 'logitic'),
		'Jost'        		  => esc_html__( 'Jost', 'logitic'),
		'Barlow'        	  => esc_html__( 'Barlow', 'logitic'),
		'Josefin Sans'        => esc_html__( 'Josefin Sans', 'logitic'),
		'Libre Baskerville'   => esc_html__( 'Libre Baskerville', 'logitic'),
		'Plus Jakarta Sans'   => esc_html__( 'Plus Jakarta Sans', 'logitic'),
		'Sarabun'   		  => esc_html__( 'Sarabun', 'logitic'),
		'Fira Sans'   		  => esc_html__( 'Fira Sans', 'logitic'),
		'Arimo'               => esc_html__( 'Arimo', 'logitic'),
		'Ubuntu'              => esc_html__( 'Ubuntu', 'logitic'),
		'Bitter'              => esc_html__( 'Bitter', 'logitic'),
		'Yantramanav'         => esc_html__( 'Yantramanav', 'logitic'),
		'Droid Serif'         => esc_html__( 'Droid Serif', 'logitic'),
		'Roboto'              => esc_html__( 'Roboto', 'logitic'),
		'Open Sans Condensed' => esc_html__( 'Open Sans Condensed', 'logitic'),
		'Roboto Condensed'    => esc_html__( 'Roboto Condensed', 'logitic'),
		'Roboto Slab'         => esc_html__( 'Roboto Slab', 'logitic'),
		'Yanone Kaffeesatz'   => esc_html__( 'Yanone Kaffeesatz', 'logitic'),
		'Rokkitt'             => esc_html__( 'Rokkitt', 'logitic'),
		'Outfit'              => esc_html__( 'Outfit', 'logitic'),
		'Maitree'             => esc_html__( 'Maitree', 'logitic'),
		'Saira Condensed'     => esc_html__( 'Saira Condensed', 'logitic'),
		'Oxanium'             => esc_html__( 'Oxanium', 'logitic'),
		'Source Code Pro'     => esc_html__( 'Source Code Pro', 'logitic'),
		'Rozha One'     	  => esc_html__( 'Rozha One', 'logitic'),
	]; 

	$font_choices = array_merge( $font_choices_custom, $font_choices_google );

	$font_weight = [
		'300' => esc_html__('300', 'logitic' ),
		'400' => esc_html__('400', 'logitic' ),
		'500' => esc_html__('500', 'logitic' ),
		'600' => esc_html__('600', 'logitic' ),
		'700' => esc_html__('700', 'logitic' ),
		'800' => esc_html__('800', 'logitic' ),
		'900' => esc_html__('900', 'logitic' ),
	];

	//Start
	$logitic_customizer->add_setting(
		'ty_header_0',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_header_0', 
			array(
				'label'			=> esc_html__( 'Header Typography', 'logitic' ),
				'settings'		=> 'ty_header_0',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_header_01', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_header_01', 
			array(
				'settings'		=> 'separator_header_01',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting( 'logitic_header_font');
	$logitic_customizer->add_control( 'logitic_header_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your desired font for the header.', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_header_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_header_font_size', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'logitic' ),
		'description'	=> esc_html__( 'Header font size (15px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_header_font_size'
	));
	//End

	//Start
	$logitic_customizer->add_setting( 'header_logitic_fonts_info', array(
			'default' => '400'
		)
	);
	$logitic_customizer->add_control( 'header_logitic_fonts_info', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'logitic' ),
			'description' => __( 'Select Header font Weight', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'ty_body_0',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_body_0', 
			array(
				'label'			=> esc_html__( 'Body Typography', 'logitic' ),
				'settings'		=> 'ty_body_0',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_body_01', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_body_01', 
			array(
				'settings'		=> 'separator_body_01',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting( 'logitic_body_font', array(
		'logitic_body_font',
		array(
			'transport'		=> 'refresh',
		)
	) );
	$logitic_customizer->add_control( 'logitic_body_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __( 'Select your desired font for the body.', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_body_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_body_font_size', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'logitic' ),
		'description'	=> esc_html__( 'Body font size (15px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_body_font_size'
	));
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_fonts_info', array(
			'default' => '400'
		)
	);
	$logitic_customizer->add_control( 'logitic_fonts_info', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'logitic' ),
			'description' => __( 'Select Body font Weight', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_1', 
			array(
				'settings'		=> 'separator_ty_1',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_0',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_0', 
			array(
				'label'			=> esc_html__( 'Heading Typography', 'logitic' ),
				'settings'		=> 'ty_heading_0',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_heading_font', array(
		'default' => esc_html__( 'Nunito Sans', 'logitic' )
	) );
	$logitic_customizer->add_control( 'logitic_heading_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'All Heading Font', 'logitic' ),
			'description' => __( 'Select your desired font for the heading.', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_1',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_1', 
			array(
				'label'			=> esc_html__( 'H1 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_1',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h1_font');
	$logitic_customizer->add_control( 'logitic_h1_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	 //Start
	 $logitic_customizer->add_setting(
		'logitic_h1_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h1_font_size', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'logitic' ),
        'description'	=> esc_html__( 'Global H1 font size (55px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h1_font_size'
    ));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h1_font_weight',
	);
	$logitic_customizer->add_control( 'logitic_h1_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'logitic' ),
			'description' => __( 'Select h1 font weight', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h1_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h1_line_height', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
        'description'	=> esc_html__( 'Global H1 font line height (30px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h1_line_height'
    ));

 	$logitic_customizer->add_setting (
        'logitic_style_h1_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_style_h1_color',
            array(
                'label'       => esc_html__('H1 Color','logitic'),
                'description' => esc_html__('Select Color','logitic'),
                'section'     => 'logitic_typography_setting',
                'settings'    => 'logitic_style_h1_color',
            )
        )
    );
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_2', 
			array(
				'settings'		=> 'separator_ty_2',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_2',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_2', 
			array(
				'label'			=> esc_html__( 'H2 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_2',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h2_font');
	$logitic_customizer->add_control( 'logitic_h2_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h2_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h2_font_size', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'logitic' ),
        'description'	=> esc_html__( 'Global H2 font size (55px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h2_font_size'
    ));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h2_font_weight',
		array(
			'transport'		=> 'refresh',
		)
	);
	$logitic_customizer->add_control( 'logitic_h2_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'logitic' ),
			'description' => __( 'Select h2 font weight', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h2_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h2_line_height', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
        'description'	=> esc_html__( 'Global H2 font line height (30px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h2_line_height'
    ));

	$logitic_customizer->add_setting (
       'logitic_style_h2_color',
   	);
   	$logitic_customizer->add_control(
       new WP_Customize_Color_Control(
           $logitic_customizer,
           'logitic_style_h2_color',
           array(
               'label'       => esc_html__('H2 Color','logitic'),
               'description' => esc_html__('Select Color','logitic'),
               'section'     => 'logitic_typography_setting',
               'settings'    => 'logitic_style_h2_color',
           )
       )
   	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_3', 
			array(
				'settings'		=> 'separator_ty_3',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_3',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_3', 
			array(
				'label'			=> esc_html__( 'H3 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_3',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h3_font');
	$logitic_customizer->add_control( 'logitic_h3_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h3_font_size',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h3_font_size', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Size', 'logitic' ),
        'description'	=> esc_html__( 'Global H3 font size (55px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h3_font_size'
    ));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h3_font_weight',
	);
	$logitic_customizer->add_control( 'logitic_h3_font_weight', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Weight', 'logitic' ),
			'description' => __( 'Select h3 font weight', 'logitic' ),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h3_line_height',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_h3_line_height', array(
        'section'		=> 'logitic_typography_setting',
        'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
        'description'	=> esc_html__( 'Global H3 font line height (30px)', 'logitic' ),
        'type'			=> 'text',
        'setting'	    => 'logitic_h3_line_height'
    ));

	$logitic_customizer->add_setting (
       'logitic_style_h3_color',
   	);
   	$logitic_customizer->add_control(
       new WP_Customize_Color_Control(
           $logitic_customizer,
           'logitic_style_h3_color',
           array(
               'label'       => esc_html__('H3 Color','logitic'),
               'description' => esc_html__('Select Color','logitic'),
               'section'     => 'logitic_typography_setting',
               'settings'    => 'logitic_style_h3_color',
           )
       )
   	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_4', 
			array(
				'settings'		=> 'separator_ty_4',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_4',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_4', 
			array(
				'label'			=> esc_html__( 'H4 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_4',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h4_font');
	$logitic_customizer->add_control( 'logitic_h4_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h4_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_h4_font_size', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'logitic' ),
		'description'	=> esc_html__( 'Global H4 font size (55px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_h4_font_size'
	));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h4_font_weight',
	);
	$logitic_customizer->add_control( 'logitic_h4_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'logitic' ),
		'description' => __( 'Select h4 font weight', 'logitic' ),
		'section'     => 'logitic_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h4_line_height',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_h4_line_height', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
		'description'	=> esc_html__( 'Global H4 font line height (30px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_h4_line_height'
	));

	$logitic_customizer->add_setting (
       'logitic_style_h4_color',
   	);
   	$logitic_customizer->add_control(
       new WP_Customize_Color_Control(
           $logitic_customizer,
           'logitic_style_h4_color',
           array(
               'label'       => esc_html__('H4 Color','logitic'),
               'description' => esc_html__('Select Color','logitic'),
               'section'     => 'logitic_typography_setting',
               'settings'    => 'logitic_style_h4_color',
           )
       )
   	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_5', 
			array(
				'settings'		=> 'separator_ty_5',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator	

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_5',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_5', 
			array(
				'label'			=> esc_html__( 'H5 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_5',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h5_font');
	$logitic_customizer->add_control( 'logitic_h5_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h5_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_h5_font_size', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'logitic' ),
		'description'	=> esc_html__( 'Global H5 font size (32px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_h5_font_size'
	));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h5_font_weight',
	);
	$logitic_customizer->add_control( 'logitic_h5_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'logitic' ),
		'description' => __( 'Select h5 font weight', 'logitic' ),
		'section'     => 'logitic_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h5_line_height',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_h5_line_height', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
		'description'	=> esc_html__( 'Global H5 font line height (30px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_h5_line_height'
	));

	$logitic_customizer->add_setting (
       'logitic_style_h5_color',
   	);
   	$logitic_customizer->add_control(
       new WP_Customize_Color_Control(
           $logitic_customizer,
           'logitic_style_h5_color',
           array(
               'label'       => esc_html__('H5 Color','logitic'),
               'description' => esc_html__('Select Color','logitic'),
               'section'     => 'logitic_typography_setting',
               'settings'    => 'logitic_style_h5_color',
           )
       )
   	);
	//End
	
	//Start separator
	$logitic_customizer->add_setting(
		'separator_ty_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_ty_6', 
			array(
				'settings'		=> 'separator_ty_6',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting(
		'ty_heading_6',
	);
	$logitic_customizer->add_control(
		new logitic_Heading_Control(
			$logitic_customizer, 
			'ty_heading_6', 
			array(
				'label'			=> esc_html__( 'H6 Typography', 'logitic' ),
				'settings'		=> 'ty_heading_6',
				'section'  		=> 'logitic_typography_setting',
			)
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting( 'logitic_h6_font');
	$logitic_customizer->add_control( 'logitic_h6_font', array(
			'type'        => 'select',
			'label'       => esc_html__( 'Font Family', 'logitic' ),
			'description' => __('Select your heading font family', 'logitic'),
			'section'     => 'logitic_typography_setting',
			'choices'     => $font_choices
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h6_font_size',
		array(
			'transport'		=> 'refresh',
		)
		);
		$logitic_customizer->add_control('logitic_h6_font_size', array(
		'section'		=> 'logitic_typography_setting',
		'label'			=> esc_html__( 'Font Size', 'logitic' ),
		'description'	=> esc_html__( 'Global H6 font size (25px)', 'logitic' ),
		'type'			=> 'text',
		'setting'	    => 'logitic_h6_font_size'
	));
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h6_font_weight',
	);
	$logitic_customizer->add_control( 'logitic_h6_font_weight', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Font Weight', 'logitic' ),
		'description' => __( 'Select h6 font weight', 'logitic' ),
		'section'     => 'logitic_typography_setting',
		'choices'     => $font_weight
		)
	);
	//End

	//Start
	$logitic_customizer->add_setting(
		'logitic_h6_line_height',
		array(
			'transport'		=> 'refresh',
		)
	);
	$logitic_customizer->add_control('logitic_h6_line_height', array(
	'section'		=> 'logitic_typography_setting',
	'label'			=> esc_html__( 'Font Line Height', 'logitic' ),
	'description'	=> esc_html__( 'Global H6 font line height (30px)', 'logitic' ),
	'type'			=> 'text',
	'setting'	    => 'logitic_h6_line_height'
	));

	$logitic_customizer->add_setting (
       'logitic_style_h6_color',
   	);
   	$logitic_customizer->add_control(
       	new WP_Customize_Color_Control(
           $logitic_customizer,
           'logitic_style_h6_color',
           	array(
               'label'       => esc_html__('H6 Color','logitic'),
               'description' => esc_html__('Select Color','logitic'),
               'section'     => 'logitic_typography_setting',
               'settings'    => 'logitic_style_h6_color',
           	)
       	)
   	);
	//End
}