<?php
function logitic_woocommerce_panel($logitic_customizer, $priority)
{
    $logitic_customizer->add_section('logitic_shop_setting', array(
        'title'    => esc_html__('Woocommerce Settings', 'logitic'),
        'priority' => $priority,
        'panel'    => 'logitic_options_panel',
    ));

    //Start
    $logitic_customizer->add_setting( 'logitic_woo_product_type', array(
        'default'           => 'default_style',
        'transport'         => 'postMessage',
    ) );
    $logitic_customizer->add_control( 'logitic_woo_product_type', array(
        'label'   => esc_html__( 'Product Style', 'logitic' ),
        'section' => 'logitic_shop_setting',
        'type'    => 'select',
        'choices' => array(
            'default_style'  => esc_html__( 'Default Style', 'logitic' ),
            'catalog_style'    => esc_html__( 'Catalog Without Price Style', 'logitic' ),
            'catalog_price_style'    => esc_html__( 'Catalog With Price Style', 'logitic' ),
        ),
    ) );
    //End

    //Start separator
    $logitic_customizer->add_setting(
        'woocommerce_hr_01',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'woocommerce_hr_01',
            array(
                'settings' => 'woocommerce_hr_01',
                'section' => 'logitic_shop_setting',
            )
        )
    );
    //End separator
    
    //Start
    $logitic_customizer->add_setting( 'logitic_shop_page_sidebar_setting', array(
        'default'           => 'shop_no_sidebar',
        'transport'         => 'postMessage',
    ) );
    $logitic_customizer->add_control( 'logitic_shop_page_sidebar_setting', array(
        'label'   => esc_html__( 'Sidebar Setting', 'logitic' ),
        'section' => 'logitic_shop_setting',
        'type'    => 'select',
        'choices' => array(
            'shop_no_sidebar'    => esc_html__( 'Full Wide', 'logitic' ),
            'shop_left_sidebar'  => esc_html__( 'Left Sidebar', 'logitic' ),
            'shop_right_sidebar' => esc_html__( 'Right Sidebar', 'logitic' ),
        ),
    ) );
    //End

    //Start separator
    $logitic_customizer->add_setting(
        'woocommerce_hr_02',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'woocommerce_hr_02',
            array(
                'settings' => 'woocommerce_hr_02',
                'section' => 'logitic_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $logitic_customizer->add_setting(
		'wc_num_product',
		array(
			'default' => esc_html__( '9', 'logitic' ),
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('wc_num_product', array(
        'section'	    => 'logitic_shop_setting',
        'label'		     => esc_html__( 'Number of Products', 'logitic' ),
        'description' => esc_html__( 'Show number of products per page', 'logitic' ),
        'type'		      => 'text',
        'setting'	    => 'wc_num_product'
    ));
	//End

    //Start separator
    $logitic_customizer->add_setting(
        'woocommerce_hr_03',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'woocommerce_hr_03',
            array(
                'settings' => 'woocommerce_hr_03',
                'section' => 'logitic_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $logitic_customizer->add_setting(
		'wc_num_product_per_row',
		array(
			'default' => esc_html__( '3', 'logitic' ),
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('wc_num_product_per_row', array(
        'section'	    => 'logitic_shop_setting',
        'label'		     => esc_html__( 'Number of Row', 'logitic' ),
        'description' => esc_html__( 'Show number of prodcts per row', 'logitic' ),
        'type'		      => 'text',
        'setting'	    => 'wc_num_product_per_row'
    ));
	//End

    //Start separator
    $logitic_customizer->add_setting(
        'woocommerce_hr_04',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'woocommerce_hr_04',
            array(
                'settings' => 'woocommerce_hr_04',
                'section' => 'logitic_shop_setting',
            )
        )
    );
    //End separator

    //Start
	 $logitic_customizer->add_setting(
		'wc_btn_txt',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('wc_btn_txt', array(
        'section'	    => 'logitic_shop_setting',
        'label'		     => esc_html__( 'Button Text', 'logitic' ),
        'description' => esc_html__( 'Default: "Add to cart", you can change it here.', 'logitic' ),
        'type'		      => 'text',
        'setting'	    => 'wc_btn_txt'
    ));
	//End
}