<?php
/**
 * @author  rs-theme
 */
function logitic_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	return $classes;
}
add_filter( 'body_class', 'logitic_body_classes' );


function rs__reading_times_grids() {
		$post = get_post();
		$words = count(preg_split('/\s+/', strip_tags( $post->post_content )));
		$minutes = floor( $words / 800 );
		$seconds = floor( $words % 800 / ( 800 / 60 ) );
		if ( 1 <= $minutes ) {
				$rs__time = ($minutes == 1 ? '': $minutes . '' ) . ' '. ($seconds == 1 ? '' :  $seconds . '' );
		} else {
				$rs__time = $seconds . '';
		}
		return $rs__time;
}

/*
Smooth Scroll Class
*/
function logitic_smooth_scroll_class( $classes ) {
	$scrollSmoother = !empty(get_theme_mod('rs_smooth_scroll_enable_disable'));
	if ( $scrollSmoother ) {
			$classes[] = 'rs-smoother-yes';
	}
	return $classes;
}

add_filter( 'body_class', 'logitic_smooth_scroll_class' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function logitic_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}

add_action( 'wp_head', 'logitic_pingback_header' );

/**  kses_allowed_html */

function logitic_prefix_kses_allowed_html($tags, $context) {
	switch($context) {
		case 'logitic': 
			$tags = array( 
				'a' => array('href' => array()),
				'b' => array()
			);
			return $tags;
		default: 
			return $tags;
	}
}

add_filter( 'wp_kses_allowed_html', 'logitic_prefix_kses_allowed_html', 10, 2);

function logitic_get_postTitleArray($postType = 'post' ) {
		$post_type_query  = new WP_Query(
				array (
						'post_type'      => $postType,
						'posts_per_page' => -1
				)
		);
		// we need the array of posts
		$posts_array      = $post_type_query->posts;
		// the key equals the ID, the value is the post_title
		if ( is_array($posts_array) ) {
				$post_title_array = wp_list_pluck($posts_array, 'post_title', 'ID' );
		}else {
			$post_title_array['default'] = esc_html__( 'Default', 'logitic' );
		}
		return $post_title_array;
}

function logitic_studio_fonts_url() {
		$font_url = '';    
		$logitic_body_font = get_theme_mod('logitic_body_font', 'Plus Jakarta Sans, sans-serif');
		$logitic_header_font = get_theme_mod('logitic_header_font', 'Outfit, sans-serif');
		$logitic_heading_font = get_theme_mod('logitic_heading_font', 'Outfit, sans-serif');
		$logitic_h1_font = get_theme_mod('logitic_h1_font', 'Outfit, sans-serif');
		$logitic_h2_font = get_theme_mod('logitic_h2_font', 'Outfit, sans-serif');
		$logitic_h3_font = get_theme_mod('logitic_h3_font', 'Outfit, sans-serif');
		$logitic_h4_font = get_theme_mod('logitic_h4_font', 'Outfit, sans-serif');
		$logitic_h5_font = get_theme_mod('logitic_h5_font', 'Outfit, sans-serif');
		$logitic_h6_font = get_theme_mod('logitic_h6_font', 'Outfit, sans-serif');

		$font_families = array();

		if ( $logitic_body_font !== 'Plus Jakarta Sans, sans-serif' ) {
				$font_families[] = $logitic_body_font;
		}
		if ( $logitic_header_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_header_font;
		}
		if ( $logitic_heading_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_heading_font;
		}
		if ( $logitic_h1_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h1_font;
		}
		if ( $logitic_h2_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h2_font;
		}
		if ( $logitic_h3_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h3_font;
		}
		if ( $logitic_h4_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h4_font;
		}
		if ( $logitic_h5_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h5_font;
		}
		if ( $logitic_h6_font !== 'Outfit, sans-serif' ) {
				$font_families[] = $logitic_h6_font;
		}
		if ( ! empty( $font_families ) ) {
				$font_url = add_query_arg( 'family', implode( '|', $font_families ) . ':400,500,600,700&display=swap', "//fonts.googleapis.com/css" );
		} else {
			$font_url = add_query_arg( array(
				'family' => 'Outfit:400,500,600,700,800,900|Plus+Jakarta+Sans:400,500,600,700',
				'display' => 'swap'
			), "//fonts.googleapis.com/css" );
		}
		return $font_url;
}

/*
Enqueue scripts and styles.
*/

function logitic_studio_scripts() {
		wp_enqueue_style( 'studio-fonts', logitic_studio_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'logitic_studio_scripts' );

//Favicon Icon
function logitic_site_icon() {
		if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) {          
		if(!empty(get_theme_mod('logitic_favicon')))
		{?>
		<link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url(get_theme_mod('logitic_favicon')); ?>"> 
	<?php 
		}
	}
}
add_filter('wp_head', 'logitic_site_icon');

//excerpt for specific section
function logitic_wpex_get_excerpt( $args = array() ) {
	// Defaults
	$defaults = array(
		'post'            => '',
		'length'          => 48,
		'readmore'        => false,
		'readmore_text'   => esc_html__( 'read more', 'logitic' ),
		'readmore_after'  => '',
		'custom_excerpts' => true,
		'disable_more'    => false,
	);
	// Apply filters
	$defaults = apply_filters( 'logitic_wpex_get_excerpt_defaults', $defaults );
	// Parse args
	$args = wp_parse_args( $args, $defaults );
	// Apply filters to args
	$args = apply_filters( 'logitic_wpex_get_excerpt_args', $defaults );
	// Extract
	extract( $args );
	// Get global post data
	if ( ! $post ) {
		global $post;
	}

	// Get post ID
	$post_id = $post->ID;

	// Check for custom excerpt
	if ( $custom_excerpts && has_excerpt( $post_id ) ) {
		$output = $post->post_excerpt;
	}
	// No custom excerpt...so lets generate one
	else {
		// Readmore link
		$readmore_link = '<a href="' . get_permalink( $post_id ) . '" class="readmore">' . $readmore_text . $readmore_after . '</a>';
		// Check for more tag and return content if it exists
		if ( ! $disable_more && strpos( $post->post_content, '<!--more-->' ) ) {
			$output = apply_filters( 'the_content', get_the_content( $readmore_text . $readmore_after ) );
		}
		// No more tag defined so generate excerpt using wp_trim_words
		else {
			// Generate excerpt
			$output = wp_trim_words( strip_shortcodes( $post->post_content ), $length );
			// Add readmore to excerpt if enabled
			if ( $readmore ) {
				$output .= apply_filters( 'logitic_wpex_readmore_link', $readmore_link );
			}

		}

	}
	// Apply filters and echo
	return apply_filters( 'logitic_wpex_get_excerpt', $output );
}

// Contact Form 7 Range slider Extender
if ( class_exists( 'WPCF7' ) ) {
	remove_action( 'wpcf7_init', 'wpcf7_add_form_tag_number' );
	add_action('wpcf7_init', 'wpcf7_range_slider_extender');
	function wpcf7_range_slider_extender() {
			wpcf7_add_form_tag( array( 'number', 'number*', 'range', 'range*' ),
			'wpcf7_range_slider_extender_handler', array( 'name-attr' => true ) );
	}
	function wpcf7_range_slider_extender_handler ( $tag ) {
			$tag = new WPCF7_FormTag( $tag );
			if ( empty( $tag->name ) ) {
					return '';
			}
			$validation_error = wpcf7_get_validation_error( $tag->name );
			$class = wpcf7_form_controls_class( $tag->type );
			$class .= ' wpcf7-validates-as-number';
			if ( $validation_error ) {
					$class .= ' wpcf7-not-valid';
			}
			$atts = array();
			$atts['class'] = $tag->get_class_option( $class );
			$atts['id'] = $tag->get_id_option();
			$atts['tabindex'] = $tag->get_option( 'tabindex', 'int', true );
			$atts['min'] = $tag->get_option( 'min', 'signed_int', true );
			$atts['max'] = $tag->get_option( 'max', 'signed_int', true );
			$atts['step'] = $tag->get_option( 'step', 'int', true );
			if ( $tag->has_option( 'readonly' ) ) {
					$atts['readonly'] = 'readonly';
			}
			if ( $tag->is_required() ) {
					$atts['aria-required'] = 'true';
			}
			$atts['aria-invalid'] = $validation_error ? 'true' : 'false';
			$value = (string) reset( $tag->values );
			if ( $tag->has_option( 'placeholder' ) || $tag->has_option( 'watermark' ) ) {
					$atts['placeholder'] = $value;
					$value = '';
			}
			$value = $tag->get_default_option( $value );
			$value = wpcf7_get_hangover( $tag->name, $value );
			$atts['value'] = $value;

			if ( wpcf7_support_html5() ) {
					$atts['type'] = $tag->basetype;
			} else {
					$atts['type'] = 'text';
			}
			$atts['name'] = $tag->name;
			$atts = wpcf7_format_atts( $atts );
			$html = sprintf(
					'<div class="rs__range_wrap"><span class="wpcf7-form-control-wrap %1$s"><input id="%5$s" oninput="output%5$s.value=%5$s.value" %2$s />%3$s</span><output class="contactform7-output" name="%1$s" id="output%5$s" for="%5$s">%4$s</output></div>',
					sanitize_html_class( $tag->name ), $atts, $validation_error, $value,  sanitize_tag_name( $tag->name ));

			return $html;
	}

	function sanitize_tag_name($string) {
			return preg_replace("/[^A-Za-z0-9]/", '', $string);
	}

}

//Demo content file include here

function logitic_import_files() {
	return array(
		array(
			'import_file_name'           => 'Logistics Company Main Demo',
			'categories'                 => array( 'Logistics' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/logistics/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/logistics/',
		),       


		array(
			'import_file_name'           => 'Logistics Company Onepage Demo',
			'categories'                 => array( 'Logistics', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/logistics/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/logistics/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/logistics/onepage',
		),        

		array(
			'import_file_name'           => 'Transportation Demo',
			'categories'                 => array( 'Transportation' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/transport/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/transportation/',
		),         

		array(
			'import_file_name'           => 'Transportation Onepage Demo',
			'categories'                 => array( 'Transportation', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/transport/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/transport/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/transportation/onepage',
		),      

		array(
			'import_file_name'           => 'Moving and Relocation Demo',
			'categories'                 => array( 'Moving', 'Relocation' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/moving/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/moving/',
		),      


		array(
			'import_file_name'           => 'Moving and Relocation Onepage Demo',
			'categories'                 => array( 'Moving', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/moving/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/moving/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/moving/onepage',
		), 

		array(
			'import_file_name'           => 'Global Logistics Demo',
			'categories'                 => array( 'Moving', 'Relocation' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/global/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/global/',
		),      


		array(
			'import_file_name'           => 'Global Logistics Onepage Demo',
			'categories'                 => array( 'Global', 'Onepage'),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/global/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/global/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/global/onepage',
		),      

		array(
			'import_file_name'           => 'Pubic Transportation Demo',
			'categories'                 => array( 'Pubic' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/public/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/public/',
		),      


		array(
			'import_file_name'           => 'Pubic Transportation Onepage Demo',
			'categories'                 => array( 'Pubic', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/public/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/public/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/public/onepage',
		),      

		array(
			'import_file_name'           => 'Logistics Shipment Demo',
			'categories'                 => array( 'Shipment' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/shipment/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/shipment/',
		),      


		array(
			'import_file_name'           => 'Logistics Shipment Onepage Demo',
			'categories'                 => array( 'Pubic', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/shipment/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/shipment/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/shipment/onepage',
		), 		

		array(
			'import_file_name'           => 'RTL Logistics Company',
			'categories'                 => array( 'RTL', 'Logistics' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/rtl/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/rtl/',
		),      


		array(
			'import_file_name'           => 'RTL Logistics Company Onepage',
			'categories'                 => array( 'RTL', 'Logistics', 'Onepage' ),
			'import_file_url'            => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-content.xml',
			'import_widget_file_url'     => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-widgets.wie',      
			'import_customizer_file_url' => 'https://rstheme.com/products/demo-data/logitic/data/rtl/logitic-customizer.dat',       
			'import_preview_image_url'   => esc_url('https://rstheme.com/products/demo-data/logitic/screens/rtl/screen.png'),   
			'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'logitic' ),
			'preview_url'                => 'https://logitic.rstheme.com/rtl/onepage',
		),    
		
	);
}

add_filter( 'pt-ocdi/import_files', 'logitic_import_files' );

function logitic_set_import_id(){
		if(isset( $_GET['import'] )) {
				$import_demo_id =(int) $_GET['import'];
				unset($_COOKIE['import_id']);
				if(!isset($_COOKIE['import_id'])) {
						setcookie('import_id', $import_demo_id, time()+3600); 
				}  
		}
}  

add_action( 'init', 'logitic_set_import_id');


function logitic_after_import_setup() {
// Assign menus to their locations.
$main_menu       = get_term_by( 'name', 'Main Menu', 'nav_menu' ); 
$mobile_menu     = get_term_by( 'name', 'Responsive Menu', 'nav_menu' ); 
$single_menu     = get_term_by( 'name', 'Onepage Menu', 'nav_menu' ); 

set_theme_mod( 'nav_menu_locations', array(
			'menu-1' => $main_menu->term_id,        
			'menu-2' => $mobile_menu->term_id,        
			'menu-3' => $single_menu->term_id        
		)
);


if(isset($_COOKIE['import_id'])) {

		$selected= (int)$_COOKIE['import_id'];
		 if($selected==0 || $selected==2 || $selected==4 || $selected==6 || $selected==8){
				$front_page_id = get_page_by_title( 'Home' ); 
		} else{
				$front_page_id = get_page_by_title( 'Onepage' ); 
		}

		$blog_page_id  = get_page_by_title( 'Blog' );
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );


		if(class_exists('RevSlider'))
		{
		if($selected==0 || $selected==1) {
				$slider = new RevSlider();
				ob_start();
				$slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/Logistics-Company.zip");
				ob_get_clean();
		}  
		if($selected==12 || $selected==13) {
				$slider = new RevSlider();
				ob_start();
				$slider->importSliderFromPost(true, true, get_template_directory()."/ocdi/sliders/RTL-Logistics.zip");
				ob_get_clean();
		}  
		}

		if($selected==0 || $selected==1) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/logistics/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}

		if($selected==2 || $selected==3 ) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/transport/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}

		if($selected==4 || $selected==5) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/moving/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}         

		if($selected==6 || $selected==7) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/global/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}         

		if($selected==8 || $selected==9) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/public/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}          

		if($selected==10 || $selected==11) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/shipment/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}  				

		if($selected==12 || $selected==13) {
			$import_kit_zip = get_parent_theme_file_path() . '/ocdi/kits/rtl/elementor-kit.zip';
			$import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
			$import_settings['referrer'] = 'remote';
			$import_export_module->import_kit( $import_kit_zip, $import_settings );
		}       

}
		unset($_COOKIE['import_id']);

}

add_action( 'pt-ocdi/after_import', 'logitic_after_import_setup' );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
// Disables the block editor from managing widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );


/**
 * Mega Menu
 */
add_action('wp_nav_menu_item_custom_fields', function($item_id, $item) {
	$show_rs_mega_class = get_post_meta($item_id, '_show-logitic-as-mega', true);
	?>
		<p class="logitic-show-as-button description description-wide">
				<label for="logitic-menu-item-btns-<?php echo esc_attr ($item_id); ?>" >
					<input type="checkbox" 
						id="logitic-menu-item-btns-<?php echo esc_attr ($item_id); ?>" 
						name="logitic-menu-item-btns[<?php echo esc_attr ($item_id); ?>]" 
						<?php checked($show_rs_mega_class, true); ?> 
					/><?php echo esc_html__('Check Mega Menu', 'logitic'); ?>
				</label>
		</p>
	<?php
}, 10, 2);

add_action('wp_update_nav_menu_item', function($menu_id, $logitic_menu_item_db_id) {
	$logitic_button_value = (isset($_POST['logitic-menu-item-btns'][$logitic_menu_item_db_id]) && $_POST['logitic-menu-item-btns'][$logitic_menu_item_db_id] === 'on') ? true : false;
	update_post_meta($logitic_menu_item_db_id, '_show-logitic-as-mega', $logitic_button_value);
}, 10, 2);

add_filter('nav_menu_css_class', function($classes, $menu_item) {
		$show_rs_mega_class = get_post_meta($menu_item->ID, '_show-logitic-as-mega', true);
		if ($show_rs_mega_class) {
				$classes[] = 'rs-mega-menu';
		}
		return $classes;
}, 10, 2);

//disable elementor default styles
update_option('elementor_disable_color_schemes', 'yes');
update_option('elementor_disable_typography_schemes', 'yes');

//added elementor support for custom post type
function logitic_custom_post_type_elementor_support() {
	$post_types = ['page', 'post', 'teams', 'careers', 'events', 'services', 'portfolios', 'elementor-rshf'];
	$elementor_support = array_merge( get_option( 'elementor_cpt_support', [] ), $post_types );
	update_option( 'elementor_cpt_support', $elementor_support );
}
add_action( 'init', 'logitic_custom_post_type_elementor_support' );

$licenseKey  = get_option("LogiticWordPressTheme_lic_Key","");
if(empty($licenseKey)) :
		add_action( 'admin_notices', 'logitic_admin_notice__success');
		function logitic_admin_notice__success() {?>
				<div class="logitic-notice notice notice-theme is-dismissible">
						<div class="logitic-notice-intro">The Logitic Theme must need to activate the purchase code. Without activation you will miss more features of the theme.  <a href="<?php echo esc_url(get_admin_url())?>/admin.php?page=logitic">Active Now!</a></div>
				</div>
				<?php 
		} 
endif;