<?php 
get_header();
$post_id      = get_the_id();
$author_id    = get_post_field ('post_author', $post_id);
$display_name = get_the_author_meta( 'display_name' , $author_id );
?>
    <div class="container"> 
        <div id="content">
            <?php
                //checking page layout
                $page_layout = get_theme_mod( 'logitic_blog_single_sidebar_setting' );
                $col_side    = '';
                $col_letf    = '';
                if($page_layout == '2left'){
                    $col_side = '8';
                    $col_letf = 'left-sidebar';
                }
                else if($page_layout == '2right'){
                    $col_side = '8';
                }
                else{
                	$col_side = '12';
            	}
                $logitic_blog_single_hide_author = get_theme_mod( 'logitic_blog_single_hide_author' );
                $logitic_blog_single_hide_comment = get_theme_mod( 'logitic_blog_single_hide_comment' );
                $logitic_blog_single_hide_published = get_theme_mod( 'logitic_blog_single_hide_published' );
                $logitic_blog_single_hide_categiry = get_theme_mod( 'logitic_blog_single_hide_categiry' );
                $logitic_blog_single_feature_img_in_col = get_theme_mod( 'logitic_blog_single_feature_img_in_col' ) ? get_theme_mod( 'logitic_blog_single_feature_img_in_col' ) : '';
            ?>
          <!-- Blog Detail Start -->
            <div class="rs-blog-details">
                <?php if (empty($logitic_blog_single_feature_img_in_col)) { ?>
                    <article id="post-<?php the_ID(); ?>">
                        <?php if(has_post_thumbnail()){ ?>
                            <div class="bs-img">
                                <?php the_post_thumbnail(); ?>
                            </div>
                        <?php } ?>
                        <div class="clear-fix"></div>           
                    </article> 
                <?php } ?>
                <div class="row padding-<?php echo esc_attr( $col_letf) ?>">
                    <div class="col-lg-<?php echo esc_attr( $col_side). ' ' .esc_attr( $col_letf) ?>">
                        <?php while ( have_posts() ) : the_post(); ?>    
                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <?php if(has_post_thumbnail() && !empty($logitic_blog_single_feature_img_in_col)){ ?>
                                    <div class="bs-img">
                                        <?php the_post_thumbnail(); ?>
                                    </div>
                                <?php } ?>
                                <?php
                                  get_template_part( 'template-parts/post/content', get_post_format() );         
                                ?>
                                <div class="clear-fix"></div>           
                            </article> 
                        
                        <?php       
                        $author_meta = get_the_author_meta('description'); 
                        if( !empty($author_meta) ){
                        ?>
                            <div class="author-block">
                              <div class="author-img"> <?php echo get_avatar(get_the_author_meta( 'ID' ), 260);?> </div>
                              <div class="author-desc">
                                <h3 class="author-title">
                                  <?php the_author();?>
                                </h3>
                                <p>
                                  <?php   
                                    echo wpautop( get_the_author_meta( 'description' ) );
                                  ?>
                                </p>
                                <a href="<?php echo esc_url(get_the_author_meta('user_url'))?>" target="_blank">
                                  <?php echo esc_url(get_the_author_meta( 'user_url'))?></a> 
                                </div>
                            </div>
                            <!-- .author-block -->
                        <?php }
                                  
                        ?>
                        <?php 
                        $blog_author = '';
                        if($blog_author == ""){
                            if ( comments_open() || get_comments_number() ) :
                                comments_template();
                            endif;
                        }
                        endwhile; // End of the loop.
                        ?>
                    </div>
                  <?php
                    if( $page_layout == '2left' || $page_layout == '2right'):
                        get_sidebar('single');
                    endif; ?>
                </div>
            </div>
          <!-- Blog Detail End --> 
        </div>
    </div>
<!-- .container -->
<?php
get_footer();