
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Email Template')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="container-fluid mt-4">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"> <?php echo e(__('Edit')); ?> <?php echo e($template->name); ?> <?php echo e(__('Template')); ?></h3>
                            <div class="card-header-links">
                                <a href="<?php echo e(route('admin.email-template')); ?>"
                                   class="card-header-link"><?php echo e(__('Back')); ?></a>
                            </div>
                        </div>
                        <div class="site-card-body">
                            <form action="<?php echo e(route('admin.email-template-update')); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($template->id); ?>">
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Email Subject')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Here the Email Subject will come"></i></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="subject" class="box-input"
                                               value="<?php echo e($template->subject); ?>" required/>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label name="" class="col-sm-3 col-label"><?php echo e(__('Banner')); ?><i icon-name="info"
                                                                                                   data-bs-toggle="tooltip"
                                                                                                   title=""
                                                                                                   data-bs-original-title="Leave it blank if you don't need the banner"></i></label>
                                    <div class="col-sm-9">
                                        <div class="wrap-custom-file">
                                            <input type="file" name="banner" id="heroRightImg"
                                                   accept=".gif, .jpg, .png">
                                            <label for="heroRightImg" <?php if($template->banner): ?> class="file-ok" style="background-image: url( <?php echo e(asset( $template->banner )); ?> )" <?php endif; ?>>
                                                <img class="upload-icon"
                                                     src="<?php echo e(asset('global/materials/upload.svg')); ?>" alt="">
                                                <span><?php echo e(__('Update Banner')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Title')); ?><i icon-name="info"
                                                                                                 data-bs-toggle="tooltip"
                                                                                                 title="Leave it blank if you don't need the title"
                                                                                                 data-bs-original-title="Leave it blank if you don't need the title"></i></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="title" class="box-input" value="<?php echo e($template->title); ?>"
                                               required/>
                                    </div>
                                </div>

                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Salutation')); ?><i icon-name="info"
                                                                                                      data-bs-toggle="tooltip"
                                                                                                      title=""
                                                                                                      data-bs-original-title="Show the Greetings here"></i></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="salutation" class="box-input"
                                               value="<?php echo e($template->salutation); ?>" required/>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Message Body')); ?><i icon-name="info"
                                                                                                        data-bs-toggle="tooltip"
                                                                                                        title=""
                                                                                                        data-bs-original-title="Write the main Messages here"></i></label>
                                    <div class="col-sm-9">
                                        <textarea name="message_body" class="form-textarea" cols="30"
                                                  rows="8"><?php echo e(br2nl($template->message_body)); ?></textarea>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Button')); ?><i icon-name="info"
                                                                                                  data-bs-toggle="tooltip"
                                                                                                  title=""
                                                                                                  data-bs-original-title="Leave it blank if you don't need the button"></i></label>
                                    <div class="col-sm-4">
                                        <input type="text" name="button_level" class="box-input"
                                               value="<?php echo e($template->button_level); ?>" required/>
                                    </div>
                                    <div class="col-sm-5">
                                        <input type="text" name="button_link" class="box-input"
                                               value="<?php echo e($template->button_link); ?>" required/>
                                    </div>
                                </div>
                                <div class="row site-input-groups">
                                    <label for="" class="col-sm-3 col-label pt-0"><?php echo e(__('Newsletter Footer')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Newsletter Footer Status"></i></label>
                                    <div class="col-sm-5">
                                        <div class="site-input-groups mb-0">
                                            <div class="switch-field mb-0">
                                                <input
                                                    type="radio"
                                                    id="welcome_user_newslatter_footer_status"
                                                    name="footer_status"
                                                    value="1"
                                                    <?php if($template->footer_status): echo 'checked'; endif; ?>
                                                />
                                                <label
                                                    for="welcome_user_newslatter_footer_status"><?php echo e(__('Enable')); ?></label>
                                                <input
                                                    type="radio"
                                                    id="welcome_user_newslatter_footer_desable"
                                                    name="footer_status"
                                                    value="0"
                                                    <?php if(!$template->footer_status): echo 'checked'; endif; ?>
                                                />
                                                <label
                                                    for="welcome_user_newslatter_footer_desable"><?php echo e(__('Disable')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Footer Message Body')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Write the footer Messages here"></i></label>
                                    <div class="col-sm-9">
                                        <textarea name="footer_body" class="form-textarea" cols="30"
                                                  rows="8"><?php echo e(br2nl($template->footer_body)); ?></textarea>
                                    </div>
                                </div>
                                <div class="row site-input-groups">
                                    <label for="" class="col-sm-3 col-label pt-0"><?php echo e(__('Newsletter Bottom')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Newslatter Bottom Status"></i></label>
                                    <div class="col-sm-5">
                                        <div class="site-input-groups mb-0">
                                            <div class="switch-field mb-0">
                                                <input
                                                    type="radio"
                                                    id="footer_bottom"
                                                    name="bottom_status"
                                                    value="1"
                                                    <?php if( $template->bottom_status): echo 'checked'; endif; ?>
                                                />
                                                <label for="footer_bottom"><?php echo e(__('Enable')); ?></label>
                                                <input
                                                    type="radio"
                                                    id="footer_bottom_disable"
                                                    name="bottom_status"
                                                    value="0"
                                                    <?php if(!$template->bottom_status): echo 'checked'; endif; ?>
                                                />
                                                <label for="footer_bottom_disable"><?php echo e(__('Disable')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <label for="" class="col-sm-3 col-label"><?php echo e(__('Newsletter Bottom Title')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Show the Greetings here"></i></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="bottom_title" class="box-input"
                                               value="<?php echo e($template->bottom_title); ?>" required/>
                                    </div>
                                </div>
                                <div class="site-input-groups row">
                                    <div class="offset-sm-3 col-sm-9">
                                        <textarea name="bottom_body" class="form-textarea" cols="30"
                                                  rows="8"><?php echo e(br2nl($template->bottom_body)); ?>   </textarea>
                                        <p class="paragraph mb-0 mt-2"><i
                                                icon-name="alert-triangle"></i><?php echo e(__('The Shortcuts you can use')); ?>

                                            <strong><?php echo e(implode(", ",json_decode($template->short_codes))); ?></strong></p>
                                    </div>
                                </div>

                                <div class="row site-input-groups">
                                    <label for="" class="col-sm-3 col-label pt-0"><?php echo e(__('Template Status')); ?><i
                                            icon-name="info" data-bs-toggle="tooltip" title=""
                                            data-bs-original-title="Template Status"></i></label>
                                    <div class="col-sm-5">
                                        <div class="site-input-groups mb-0">
                                            <div class="switch-field mb-0">
                                                <input
                                                    type="radio"
                                                    id="template_status_enable"
                                                    name="status"
                                                    value="1"
                                                    <?php if($template->status): echo 'checked'; endif; ?>
                                                />
                                                <label for="template_status_enable"><?php echo e(__('Enable')); ?></label>
                                                <input
                                                    type="radio"
                                                    id="template_status_disable"
                                                    name="status"
                                                    value="0"
                                                    <?php if(!$template->status): echo 'checked'; endif; ?>
                                                />
                                                <label for="template_status_disable"><?php echo e(__('Disable')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="offset-sm-3 col-sm-9">
                                        <button type="submit"
                                                class="site-btn-sm primary-btn w-100"><?php echo e(__('Save Changes')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/backend/email/edit.blade.php ENDPATH**/ ?>