<?php $__env->startSection('title'); ?>
    <?php echo e(__('Schema Preview')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-xl-10 col-lg-12 col-md-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Review and Confirm Investment')); ?></h3>
                </div>
                <div class="site-card-body">
                    <form action="<?php echo e(route('user.invest-now')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="progress-steps-form">
                            <div class="transaction-list table-responsive">
                                <table class="table preview-table">
                                    <tbody>
                                    <tr>
                                        <td><strong><?php echo e(__('Select Schema:')); ?></strong></td>
                                        <td>
                                            <div class="input-group mb-0">
                                                <select class="site-nice-select" aria-label="Default select example"
                                                        id="select-schema" name="schema_id" required>
                                                    <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($plan->id); ?>"
                                                                <?php if($plan->id == $schema->id ): ?> selected <?php endif; ?>><?php echo e($plan->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td><strong><?php echo e(__('Profit Holiday:')); ?></strong></td>
                                        <td id="holiday">
                                            <?php if( null != $schema->off_days): ?> <?php echo e(implode(', ', json_decode($schema->off_days,true))); ?>  <?php else: ?> <?php echo e(__('No')); ?> <?php endif; ?>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td><strong><?php echo e(__('Amount:')); ?></strong></td>
                                        <td id="amount">
                                            <?php echo e($schema->type == 'range' ? 'Minimum ' . $schema->min_amount .' '.$currency. ' - ' . 'Maximum ' . $schema->max_amount.' '.$currency :  $schema->fixed_amount.' '.$currency); ?>

                                        </td>
                                    </tr>

                                    <tr>
                                        <td><strong><?php echo e(__('Enter Amount:')); ?></strong></td>
                                        <td>
                                            <div class="input-group mb-0">
                                                <input type="text" class="form-control"
                                                       <?php if($schema->type == 'fixed'): ?> value="<?php echo e($schema->fixed_amount); ?>"
                                                       readonly <?php endif; ?> placeholder="Enter Amount"
                                                       oninput="this.value = validateDouble(this.value)"
                                                       aria-label="Amount" name="invest_amount" id="enter-amount"
                                                       aria-describedby="basic-addon1" required>
                                                <span class="input-group-text" id="basic-addon1"><?php echo e($currency); ?></span>
                                            </div>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td><strong><?php echo e(__('Select Wallet:')); ?></strong></td>
                                        <td>
                                            <div class="input-group mb-0">
                                                <select class="site-nice-select" aria-label="Default select example"
                                                        name="wallet" required id="selectWallet">
                                                    <option
                                                        value="main"><?php echo e(__('Main Wallet ( ') . $user->balance.' '. $currency); ?>

                                                        )
                                                    </option>
                                                    <option
                                                        value="profit"><?php echo e(__('Profit Wallet ( ') . $user->profit_balance.' '. $currency); ?>

                                                        )
                                                    </option>
                                                    <option value="gateway"><?php echo e(__('Direct Gateway')); ?></option>
                                                </select>
                                            </div>

                                        </td>
                                    </tr>

                                    <tr class="gatewaySelect">

                                    </tr>

                                    <tr>
                                        <td colspan="2">
                                            <div class="row manual-row"></div>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td><strong><?php echo e(__('Return of Interest:')); ?></strong></td>
                                        <td id="return-interest"><?php echo e(($schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $schema->return_interest.' '.$currency ) .' ('.$schema->schedule->name .')'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo e(__('Number of Period:')); ?></strong></td>
                                        <td id="number-period"><?php echo e(( $schema->return_type == 'period' ? $schema->number_of_period : 'Unlimited').($schema->number_of_period == 1 ? ' Time' : ' Times' )); ?> </td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo e(__('Capital Back:')); ?></strong></td>
                                        <td id="capital_back"><?php echo e($schema->capital_back ? 'Yes' : 'No'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo e(__('Total Investment Amount:')); ?></strong></td>
                                        <td><span
                                                id="total-amount"> <?php echo e($schema->fixed_amount ?? ''); ?></span> <?php echo e($currency); ?>

                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="button">
                                <button type="submit" class="site-btn primary-btn me-3">
                                    <i class="anticon anticon-check"></i><?php echo e(__('Invest Now')); ?>

                                </button>
                                <a href="<?php echo e(route('user.schema')); ?>" class="site-btn black-btn">
                                    <i class="anticon anticon-stop"></i><?php echo e(__('Cancel')); ?>

                                </a>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $("#select-schema").on('change',function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).val();

            var invest_amount = $("#enter-amount");
            invest_amount.val('');
            invest_amount.attr('readonly', false);

            var url = '<?php echo e(route("user.schema.select", ":id")); ?>';
            url = url.replace(':id', id);

            $.ajax({
                url: url, success: function (result) {
                    $('#amount').html(result.amount_range);
                    $('#holiday').html(result.holiday);
                    $('#return-interest').html(result.return_interest);
                    $('#number-period').html(result.number_period);
                    $('#capital_back').html(result.capital_back);

                    if (result.invest_amount > 0) {
                        invest_amount.val(result.invest_amount);
                        invest_amount.attr('readonly', true);
                    }

                }
            });
        });
        $("#enter-amount").on('keyup',function (e) {
            "use strict";
            e.preventDefault();
            var amount = $(this).val();
            $("#total-amount").html(amount);
        })

        $("#selectWallet").on('change',function (e) {
            "use strict";
            $('.gatewaySelect').empty();
            $('.manual-row').empty();
            var wallet = $(this).val();
            if (wallet === 'gateway') {
                $.get('<?php echo e(route('gateway.list')); ?>', function (data) {
                    $('.gatewaySelect').append(data)
                    $('select').niceSelect();

                });
            }

        })
        $('body').on('change', '#gatewaySelect', function (e) {
            "use strict"
            e.preventDefault();

            $('.manual-row').empty();

            var code = $(this).val()

            var url = '<?php echo e(route("user.deposit.gateway",":code")); ?>';
            url = url.replace(':code', code);
            $.get(url, function (data) {

                if (data.credentials !== undefined) {

                    console.log(data.credentials);

                    $('.manual-row').append(data.credentials)
                    imagePreview()
                }


            });

            $('#amount').on('keyup',function (e) {
                "use strict"
                var amount = $(this).val()
                $('.amount').text((Number(amount)))
                $('.currency').text(currency)
                var charge = globalData.charge_type === 'percentage' ? calPercentage(amount, globalData.charge) : globalData.charge
                $('.charge2').text(charge + ' ' + currency)

                $('.total').text((Number(amount) + Number(charge)) + ' ' + currency)
            })


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/frontend/schema/preview.blade.php ENDPATH**/ ?>