@extends('admin.layouts.master')
@section('title',__('breadcrumb'))
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{route('general.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label >@lang('Header Text')</label>
                        <input type="text" class="form-control" name="banner_header" value="{{$general->banner_header}}">
                    </div>

                    <div class="form-group col-md-4">
                        <label >@lang('Body Text')</label>
                        <input type="text" class="form-control" name="banner_body" value="{{$general->banner_body}}">
                    </div>

                    <div class="form-group col-md-4">
                        <label >@lang('Footer Text')</label>
                        <input type="text" class="form-control" name="banner_footer" value="{{$general->banner_footer}}">
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="form-group col-md-3">
                        <label >@lang('Header Background Image') <small>@lang('(PNG format is standard)')</small></label>
                        <input type="file" id="file-input" class="form-control" name="banner_bg_image">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain'>
                                    <img id="image-preview" class="img-fluid" align='middle' src="{{asset('public/images/banner/bg.png')}}" alt="your image" title=''/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <label >@lang('Front Image') <small>@lang('(PNG format is standard)')</small></label>
                        <input type="file" id="file-input2" class="form-control" name="banner_front_image">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain2'>
                                    <img id="image-preview2" class="img-fluid" align='middle' src="{{asset('public/images/banner/front.png')}}" alt="your image" title=''/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <label >@lang('Breadcrumb Image') <small>@lang('(PNG format is standard)')</small></label>
                        <input type="file" id="file-input3" class="form-control" name="bread_front_image">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain3'>
                                    <img id="image-preview3" class="img-fluid" align='middle' src="{{asset('public/images/banner/bred.png')}}" alt="your image" title=''/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label class="form-label">@lang('Footer Breadcrumb Image') <small>@lang('(PNG format is standard)')</small></label>
                        <input type="file" id="file-input3" class="form-control" name="bread_footer_image">
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div id='img_contain3'>
                                    <img id="image-preview3" class="img-fluid" align='middle' src="{{asset('public/images/banner/footer.png')}}" alt="your image" title=''/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base ">@lang('Update')</button>
                </div>
            </form>

        </div>
    </div>
@endsection
