@extends($theme.'frontend.layouts.master')
@section('title',__(isset($title) ? $title: 'Single Page'))
@section('content')
    <div class="blog-area pd-top-120 pd-bottom-120">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="blog-details-page-content">
                        <div class="single-blog-inner">
                            @isset($image)
                            <div class="thumb">
                                <img src="{{$image}}" alt="img">
                            </div>
                            @endif
                            <div class="details">
                                <ul class="blog-meta">
                                    <li><i class="far fa-user"></i> {{__('By Admin')}}</li>
                                    @isset($updated_at)
                                        <li><i class="far fa-clock"></i> {{date('d M Y',strtotime($updated_at))}}</li>
                                    @endif
                                </ul>
                                @isset($description)
                                <p>{!! nl2br($description) !!}</p>
                                @endif
                                <div class="tag-and-share">
                                    <div class="tags d-inline-block">
                                        <strong>{{__('Share')}} : </strong>
                                        <a href="https://www.facebook.com/sharer/sharer.php?u={{urlencode(url()->current()) }}" target="_blank" class="facebook"> <i class="fab fa-facebook-f" aria-hidden="true"></i></a>
                                        <a href="https://twitter.com/intent/tweet?text=my share text&amp;url={{urlencode(url()->current()) }}" target="_blank" class="twitter"><i class="fab fa-twitter" aria-hidden="true"></i></a>
                                        <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{urlencode(url()->current()) }}&amp;title=my share text&amp;summary=dit is de linkedin summary" target="_blank" class="linkedin"><i class="fab fa-linkedin" aria-hidden="true"></i></a>
                                        <a href="https://plus.google.com/share?url={{urlencode(url()->current()) }}" target="_blank" class="google"><i class="fab fa-google-plus" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="blog-comment">
                            <div class="comments">
                                <div id="fb-root"></div>
                                <script>(function(d, s, id) {
                                        var js, fjs = d.getElementsByTagName(s)[0];
                                        if (d.getElementById(id)) return;
                                        js = d.createElement(s); js.id = id;
                                        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.8&appId=1421567158073949";
                                        fjs.parentNode.insertBefore(js, fjs);
                                    }(document, 'script', 'facebook-jssdk'));
                                </script>
                                <div class="fb-comments" data-href="{{ url()->current() }}" data-width="100%" data-numposts="5"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-12">
                    <div class="td-sidebar">
                        <div class="widget widget_author text-center">
                            <div class="details">
                                <h5>{{__('Follow Us')}}</h5>
                                <ul class="social-media">
                                    @foreach($social as $data)
                                    <li><a href="{{$data->link}}" target="_blank" class="{{$data->icon}}"><i class="fab fa-{{$data->icon}}" aria-hidden="true"></i></a></li>
                                @endforeach
                                </ul>
                            </div>
                        </div>                 
                        <div class="widget widget-recent-post">             
                            <h4 class="widget-title">{{__('Recent News Posts')}}</h4>
                            <ul>
                                @foreach($recentPostSingle as $data)
                                <li>
                                    <div class="media">
                                        <div class="media-left">
                                            <img class="recent_post_img" src="{{asset('public/images/news/'.$data->image)}}" alt="blog">
                                        </div>
                                        <div class="media-body align-self-center">
                                            <h6 class="title"><a href="{{route('single.page',['class' => 'news','id'=>$data->id])}}">{{$data->title}}</a></h6>
                                            <div class="post-info"><i class="far fa-calendar-alt"></i><span>{{date('M d, Y',strtotime($data->updated_at))}}</span></div>                     
                                        </div>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop