<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('clean',function(){
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
 }); 
 
Route::get('/cron', 'UiController@cronAction');

Route::group(['prefix' => 'admin','namespace'=> 'Admin'], function () {
    Route::get('/', 'AdminLoginController@showAdminLoginForm');
    Route::post('/', 'AdminLoginController@adminLogin')->name('admin.login');

    Route::group(['middleware' => ['auth:admin']], function () {
        Route::get('dashboard', 'AdminController@adminIndex')->name('admin.home');

        Route::group(['middleware'=>'permission:settings'],function (){
            Route::post('general', 'GeneralController@generalStore')->name('general.store');
            Route::get('settings', 'AdminController@gnlSetting')->name('admin.gnl.set');
            Route::get('select/template', 'AdminController@selTemplate')->name('admin.gnl.template');
        });

        Route::group(['middleware'=>'permission:language'],function (){
            Route::get('/language/manager', 'LanguageController@langManage')->name('language-manage');
            Route::post('/language/manager', 'LanguageController@langStore')->name('language-manage-store');
            Route::delete('language-manage/{id}', 'LanguageController@langDel')->name('language-manage-del');
            Route::get('language-key/{id}', 'LanguageController@langEdit')->name('language-key');
            Route::put('key-update/{id}', 'LanguageController@langUpdate')->name('key-update');
            Route::post('language-manage-update/{id}', 'LanguageController@langUpdatepp')->name('language-manage-update');
            Route::post('language-import', 'LanguageController@langImport')->name('import_lang');
        });

        Route::group(['middleware'=>'permission:theme'],function (){
            Route::get('/manage/theme', 'GeneralController@manageTheme')->name('manage.theme');
            Route::put('/activate/theme/{name}', 'GeneralController@activateTheme')->name('activate.themeUpdate');
        });

        Route::resource('faq', FaqsController::class);

        Route::group(['middleware'=>'permission:identity_form'],function (){
            Route::get('/identity-form', 'IdentyVerifyFromController@index')->name('identify-form.index');
            Route::post('/identity-form', 'IdentyVerifyFromController@store')->name('identify-form.store');
        });

        Route::get('notifications','NotificationController@notifications')->name('admin.notifications');
        Route::get('notification/read/{id}','NotificationController@notificationRead')->name('admin.notification.read');
        Route::get('notifications/read-all','NotificationController@readAll')->name('admin.notifications.readAll');

         Route::group(['middleware'=>'permission:email_settings'],function (){
            Route::resource('email-template', EmailTemplateController::class);
            Route::get('email-controls', 'EmailTemplateController@emailControl')->name('admin.email-controls');
            Route::post('email-controls', 'EmailTemplateController@emailConfigure')->name('admin.email-controls.update');
            Route::get('global-template', 'EmailTemplateController@globalControl')->name('admin.global-template');
            Route::post('global-template', 'EmailTemplateController@globalConfigure')->name('admin.global-template.update');
            Route::post('email-template/{id}/update', 'EmailTemplateController@update')->name('email-template.update');

        });

        Route::group(['middleware'=>'permission:banner'],function (){
            Route::get('banner', 'GeneralController@bannerIndex')->name('banner.index');
        });

        Route::group(['middleware'=>'permission:logo'],function (){
            Route::get('logo-icon', 'GeneralController@logoIcon')->name('logo-icon.index');
        });

        Route::group(['middleware'=>'permission:web_interface'],function (){
            Route::get('about', 'GeneralController@aboutIndex')->name('about-area.index');

            Route::get('work-area', 'WorkAreaController@workIndex')->name('work-area.index');
            Route::get('work-area/create', 'WorkAreaController@workCreate')->name('work-area.create');
            Route::post('work-area', 'WorkAreaController@workStore')->name('work-area.store');
            Route::get('work-area/{workArea}', 'WorkAreaController@workEdit')->name('work-area.edit');
            Route::put('work-area/{workArea}', 'WorkAreaController@workUpdate')->name('work-area.update');
            Route::delete('work-area/{workArea}', 'WorkAreaController@workDelete')->name('work-area.delete');
    
            Route::get('service-area', 'ServiceController@workIndex')->name('service-area.index');
            Route::get('service-area/create', 'ServiceController@workCreate')->name('service-area.create');
            Route::post('service-area', 'ServiceController@workStore')->name('service-area.store');
            Route::get('service-area/{workArea}', 'ServiceController@workEdit')->name('service-area.edit');
            Route::put('service-area/{workArea}', 'ServiceController@workUpdate')->name('service-area.update');
            Route::delete('service-area/{workArea}', 'ServiceController@workDelete')->name('service-area.delete');
    
            Route::get('investor-area', 'InvestorController@workIndex')->name('investor-area.index');
            Route::get('investor-area/create', 'InvestorController@workCreate')->name('investor-area.create');
            Route::post('investor-area', 'InvestorController@workStore')->name('investor-area.store');
            Route::get('investor-area/{workArea}', 'InvestorController@workEdit')->name('investor-area.edit');
            Route::put('investor-area/{workArea}', 'InvestorController@workUpdate')->name('investor-area.update');
            Route::delete('investor-area/{workArea}', 'InvestorController@workDelete')->name('investor-area.delete');
    
            Route::get('partner-area', 'PartnerController@workIndex')->name('partner-area.index');
            Route::post('partner-area', 'PartnerController@workStore')->name('partner-area.store');
            Route::put('partner-area/{workArea}', 'PartnerController@workUpdate')->name('partner-area.update');
            Route::delete('partner-area/{workArea}', 'PartnerController@workDelete')->name('partner-area.delete');

            Route::get('social-area', 'SocialController@workIndex')->name('social-area.index');
            Route::post('social-area', 'SocialController@workStore')->name('social-area.store');
            Route::put('social-area/{workArea}', 'SocialController@workUpdate')->name('social-area.update');
            Route::delete('social-area/{workArea}', 'SocialController@workDelete')->name('social-area.delete');

        });

        Route::group(['middleware'=>'permission:news'],function (){
            Route::get('news-area', 'NewsController@workIndex')->name('news-area.index');
            Route::get('news-area/create', 'NewsController@workCreate')->name('news-area.create');
            Route::post('news-area', 'NewsController@workStore')->name('news-area.store');
            Route::get('news-area/{workArea}', 'NewsController@workEdit')->name('news-area.edit');
            Route::put('news-area/{workArea}', 'NewsController@workUpdate')->name('news-area.update');
            Route::delete('news-area/{workArea}', 'NewsController@workDelete')->name('news-area.delete');
        });

        Route::group(['middleware'=>'permission:menu'],function (){
            Route::get('menu-area', 'MenuController@workIndex')->name('menu-area.index');
            Route::get('menu-area/create', 'MenuController@workCreate')->name('menu-area.create');
            Route::post('menu-area', 'MenuController@workStore')->name('menu-area.store');
            Route::get('menu-area/{workArea}', 'MenuController@workEdit')->name('menu-area.edit');
            Route::put('menu-area/{workArea}', 'MenuController@workUpdate')->name('menu-area.update');
            Route::delete('menu-area/{workArea}', 'MenuController@workDelete')->name('menu-area.delete');
        });

        Route::group(['middleware'=>'permission:plan'],function (){
            Route::get('plan-area', 'PlanController@workIndex')->name('plan-area.index');
            Route::get('plan-area/create', 'PlanController@workCreate')->name('plan-area.create');
            Route::post('plan-area', 'PlanController@workStore')->name('plan-area.store');
            Route::get('plan-area/{workArea}', 'PlanController@workEdit')->name('plan-area.edit');
            Route::put('plan-area/{workArea}', 'PlanController@workUpdate')->name('plan-area.update');
            Route::delete('plan-area/{workArea}', 'PlanController@workDelete')->name('plan-area.delete');
        });
        
        Route::group(['middleware'=>'permission:schedule'],function (){
            Route::get('/schedule-manage', 'PlanController@scheduleIndex')->name('scheduleIndex');
            Route::post('/schedule-create', 'PlanController@storeSchedule')->name('store.schedule');
            Route::put('/schedule-update/{id}', 'PlanController@updateSchedule')->name('update.schedule');
        });

        Route::group(['middleware'=>'permission:gateway_management'],function (){
            Route::get('gateway', 'GatewayController@show')->name('gateway');
            Route::post('gateway', 'GatewayController@update')->name('update.gateway');
            Route::post('gateway/store', 'GatewayController@store')->name('store.gateway');
        });

        Route::group(['middleware'=>'permission:withdraw_method'],function (){
            Route::get('withdraw-method', 'WithDrawMethodController@indexWithdraw')->name('add.withdraw.method');
            Route::post('withdraw-store', 'WithDrawMethodController@storeWithdraw')->name('store.withdraw.method');
            Route::put('withdraw/update/{id}', 'WithDrawMethodController@updateWithdraw')->name('update.withdraw.method');
        });
        
        Route::group(['middleware'=>'permission:withdraw_pending'],function (){
            Route::get('withdraw/requests', 'WithDrawMethodController@requestWithdraw')->name('withdraw.request.index');
            Route::get('withdraw/details/{id}', 'WithDrawMethodController@detailWithdraw')->name('withdraw.detail.user');
            Route::post('withdraw/update/{id}', 'WithDrawMethodController@repondWithdraw')->name('withdraw.process');
        });

        Route::group(['middleware'=>'permission:withdraw_log'],function (){
            Route::get('withdraw/log', 'WithDrawMethodController@showWithdrawLog')->name('withdraw.viewlog.admin');
        });

        Route::group(['middleware'=>'permission:support'],function (){
            Route::get('support', 'SupportController@supportIndex')->name('support.index');
            Route::get('/support/reply/{support}', 'SupportController@adminSupport')->name('support.admin.reply');
            Route::post('/reply/{support}', 'SupportController@adminReply')->name('store.admin.reply');
        });

        Route::group(['middleware'=>'permission:ico'],function (){
            Route::get('ico', 'GeneralController@icoIndex')->name('ico_settings.index');
        });
        
        Route::group(['middleware'=>'permission:manage_user'],function (){
            Route::get('user-group','ManageUserController@index')->name('admin.user_group');
            Route::get('group/create','ManageUserController@create')->name('admin.group.create');
            Route::post('group/store','ManageUserController@store')->name('admin.group.store');
            Route::get('group/{id}/edit','ManageUserController@edit')->name('admin.group.edit');
            Route::post('group/{id}/update','ManageUserController@update')->name('admin.group.update');
            Route::get('user','ManageUserController@getUser')->name('admin.user');
            Route::post('user/store','ManageUserController@userStore')->name('admin.user.store');
            Route::post('user/update/{id}','ManageUserController@userUpdate')->name('admin.user.update');
        });

        Route::group(['middleware'=>'permission:pending_kyc'],function (){
            Route::get('users/kyc/pending', 'AdminController@kycPendingList')->name('kyc.users.pending');
            Route::put('users/kycAction/{id}', 'AdminController@kycAction')->name('users.Kyc.action');
            Route::get('user/{user}/kyc', 'AdminController@userKycHistory')->name('user.userKycHistory');
        });
        
        Route::group(['middleware'=>'permission:log_kyc'],function (){
            Route::get('users/kyc', 'AdminController@kycList')->name('kyc.users');
        });
        
        Route::group(['middleware'=>'permission:google_tools'],function (){
            Route::get('google-tools', 'GeneralController@googleToolsIndex')->name('google_tools.index');
        });
        
        Route::group(['middleware'=>'permission:user_management'],function (){
            Route::get('users', 'AdminController@usersIndex')->name('user.manage');
            Route::get('users/detail/{id}', 'AdminController@indexUserDetail')->name('user.view');
            Route::GET('user/search', 'AdminController@userSearch')->name('username.search');
            Route::GET('user/search/email', 'AdminController@userSearchEmail')->name('email.search');
            Route::post('users/amount/{id}', 'AdminController@indexBalanceUpdate')->name('user.balance.update');
            Route::get('users/send/mail/{id}', 'AdminController@userSendMail')->name('user.mail.send');
            Route::post('send/mail/{id}', 'AdminController@userSendMailUser')->name('send.mail.user');
            Route::get('users/balance/{id}', 'AdminController@indexUserBalance')->name('add.subs.index');
            Route::put('users/update/{id}', 'AdminController@userUpdate')->name('user.detail.update');
            
            Route::post('active/wallet/users/update/{id}', 'AdminController@activeUserUpdate')->name('adm-active-wallet.update');
            Route::post('reject/wallet/users/update/{id}', 'AdminController@rejectUserUpdate')->name('adm-reject-wallet.update');
        });

        Route::group(['middleware'=>'permission:active_user'],function (){
            Route::get('active-user', 'AdminController@usersActiveIndex')->name('active.user.manage');
        });

        Route::group(['middleware'=>'permission:ban_user'],function (){
            Route::get('ban-user', 'AdminController@usersBanndedIndex')->name('ban.user.manage');
        });
        
        Route::group(['middleware'=>'permission:deposit_pending'],function (){
            Route::get('deposit/pending','DepositController@pending')->name('admin.deposit.pending');
            Route::get('deposit/showReceipt', 'DepositController@showReceipt')->name('admin.deposit.showReceipt');
            Route::post('deposit/accept', 'DepositController@accept')->name('admin.deposit.accept');
            Route::post('deposit/rejectReq','DepositController@rejectReq')->name('admin.deposit.rejectReq');
        });

        Route::group(['middleware'=>'permission:deposit_accept'],function (){
            Route::get('deposit/acceptedRequests','DepositController@acceptedRequests')->name('admin.deposit.acceptedRequests');
        });

        Route::group(['middleware'=>'permission:deposit_log'],function (){
            Route::get('deposit/depositLog','DepositController@depositLog')->name('admin.deposit.depositLog');
        });

        Route::group(['middleware'=>'permission:deposit_reject'],function (){
            Route::get('deposit/rejectedRequests','DepositController@rejectedRequests')->name('admin.deposit.rejectedRequests');
        });
        
        Route::group(['middleware'=>'permission:transaction'],function (){
            Route::get('transactions', 'AdminController@transactionIndex')->name('transaction.log.admin');
            Route::get('search-transaction/', 'AdminController@searchResult')->name('search.trans.admin');
        });
        
        Route::group(['middleware'=>'permission:referral'],function (){
            Route::get('referral', 'AdminController@referralIndex')->name('admin.referral');
            Route::post('referral', 'AdminController@referralStore')->name('admin.referral.update');
        });

        Route::get('profile', 'AdminController@changePass')->name('admin.changePass');
        Route::post('profile/updatePassword', 'AdminController@updatePassword')->name('admin.updatePassword');

        Route::get('logout', 'AdminController@adminLogout')->name('admin.logout');
    });
});

Auth::routes();
Route::get('register/{referral_token}', 'Auth\RegisterController@showRegistrationForm');

Route::get('/login/google', 'Auth\LoginController@redirectToGoogle')->name('login.google');
Route::get('/login/google/callback', 'Auth\LoginController@handleGoogleCallback');

Route::get('/login/facebook', 'Auth\LoginController@redirectToFacebook')->name('login.facebook');
Route::get('/login/facebook/callback', 'Auth\LoginController@handleFacebookCallback');

Route::get('/', 'UiController@index');
Route::get('/change-lang/{lang}', 'UiController@changeLang')->name('lang');

Route::get('single/{class?}/{id?}', 'UiController@singlePage')->name('single.page');
Route::get('news', 'UiController@newsIndex')->name('news.index');
Route::get('contact', 'UiController@contactsIndex')->name('contacts.index');


Route::get('/showEmailForm', 'Auth\ForgotPasswordController@showEmailForm')->name('user.showEmailForm');
Route::post('/sendResetPassMail', 'Auth\ForgotPasswordController@sendResetPassMail')->name('user.sendResetPassMail');
Route::get('/reset/{code}', 'Auth\ForgotPasswordController@resetPasswordForm')->name('user.resetPasswordForm');
Route::post('/resetPassword', 'Auth\ForgotPasswordController@resetPassword')->name('user.resetPassword');

    Route::get('/authorization', 'HomeController@authorization')->name('authorization');
    Route::post('/sendemailver', 'HomeController@sendemailver')->name('sendemailver');
    Route::post('/emailverify', 'HomeController@emailverify')->name('emailverify');
    Route::post('/g2fa-verify', 'HomeController@verify2fa')->name('go2fa.verify');

Route::group(['middleware' => ['auth','ckstatus']], function () {
    Route::group(['middleware' => ['kyc']], function () {

        Route::get('home', 'HomeController@index')->name('home');
        Route::get('invest', 'HomeController@investIndex')->name('invest.index');
        Route::get('wallet', 'HomeController@walletIndex')->name('wallet.index');
        Route::get('my-wallet-transaction', 'HomeController@myWalletTransactionIndex')->name('my.wallet.transaction.log');
        Route::get('other-wallet-transaction', 'HomeController@otherWalletTransactionIndex')->name('other.wallet.transaction.log');

        Route::post('confirm-coin-wallet/{id}', 'HomeController@confirmWallet')->name('confirm-coin-wallet.store');
        Route::post('reject-coin-wallet/{id}', 'HomeController@rejectWallet')->name('reject-coin-wallet.store');

        Route::get('invest-log', 'HomeController@investLog')->name('invest.log');
        Route::get('transaction-log', 'HomeController@transactionLog')->name('transaction.log');
        Route::get('min-crypto', 'HomeController@purchaseCoin')->name('purchase.coin');
        Route::post('min-crypto', 'HomeController@purchaseCoinStore')->name('purchase-coin.store');
        Route::post('min-crypto-send', 'HomeController@purchaseCoinSendStore')->name('purchase-coin-send.store');
        Route::post('min-crypto-receive', 'HomeController@purchaseCoinReceiveStore')->name('purchase-coin-receive.store');
        Route::get('fund-transfer', 'HomeController@fundTransIndex')->name('fund.transfer');
        Route::post('fund-transfer', 'HomeController@fundTransStore')->name('transfer.store');
        Route::post('purchase/{plan}', 'HomeController@purPlan')->name('purchase.plan');
        Route::get('withdraw', 'HomeController@withdrawIndex')->name('user.withdraw.method');
        Route::post('withdraw/preview', 'HomeController@withdrawPreview')->name('withdraw.preview.user');
        Route::post('confirm/withdraw', 'HomeController@storeWithdraw')->name('confirm.withdraw.store');
         Route::get('withdraw-log', 'HomeController@withdrawLog')->name('user.withdraw.log');

        Route::post('new-wallet', 'HomeController@newWalletStore')->name('new-wallet.store');

        Route::match(['get', 'post'], 'deposit', 'PaymentGatwayController@addDeposit')->name('users.showDepositMethods');
        Route::post('deposit-amount-insert', 'PaymentGatwayController@depositAmountInsert')->name('submit.amount.deposit');

        Route::get('deposit-preview', 'PaymentGatwayController@depositPreview')->name('user.deposit.preview');
        Route::post('deposit-confirm', 'PaymentGatwayController@depositPayNow')->name('deposit.confirm');
        Route::get('deposit-log', 'HomeController@depositLog')->name('user.deposit.log');

        Route::get('referral/{level?}', 'HomeController@myRef')->name('user.ref.index');

        Route::get('search-transaction/', 'HomeController@searchTrans')->name('search.trans.user');

    });

    Route::get('profile', 'HomeController@profileIndex')->name('profile.index');
    Route::post('profile', 'HomeController@profileUpdate')->name('profile.update');
    Route::post('password', 'HomeController@passwordUpdate')->name('password.update');

    Route::get('/security/two/step', 'HomeController@twoFactorIndex')->name('two.factor.index');
    Route::post('/g2fa-create', 'HomeController@create2fa')->name('go2fa.create');
    Route::post('/g2fa-disable', 'HomeController@disable2fa')->name('disable.2fa');

    Route::post('bvn', 'HomeController@kycUpdate')->name('kyc.update');

    Route::get('kyc', 'HomeController@kycIndex')->name('user.kyc.index');
    Route::post('/verificationSubmit', 'HomeController@verificationSubmit')->name('user.verificationSubmit');

    Route::get('support/ticket', 'Admin\SupportController@customerSupportIndex')->name('customer.support.index');
    Route::get('support/new', 'Admin\SupportController@ticketCreate')->name('customer.new.ticket');
    Route::post('store/ticket', 'Admin\SupportController@ticketStore')->name('ticket.store');
    Route::get('comment/close/{support}', 'Admin\SupportController@ticketClose')->name('ticket.close');
    Route::get('support/reply/{support}', 'Admin\SupportController@ticketReply')->name('ticket.customer.reply');
    Route::post('support/store/{support}', 'Admin\SupportController@ticketReplyStore')->name('store.customer.reply');
});

//ipn
Route::get('payment', 'PayPalController@payment');
Route::get('cancel', 'PayPalController@cancel')->name('paypal.payment.cancel');
Route::get('payment/success', 'PayPalController@success')->name('paypal.payment.success');

Route::post('/ipncoin', 'CoinpaymentController@ipnCoin')->name('ipn.coinpayemnt');
Route::post('/ipnstripe', 'StripeController@ipnstripe')->name('ipn.stripe');

Route::any('/payfast-success', 'PayFastController@success')->name('payfast.payment.success');
Route::any('/payfast-cancel', 'PayFastController@cancel')->name('payfast.payment.cancel');
Route::any('/payfast-notify', 'PayFastController@notify')->name('payfast.payment.notify');

Route::post('/paystack-pay', 'PayStackController@redirectToGateway')->name('paystack.pay');
Route::get('/paystack-payment/callback', 'PayStackController@handleGatewayCallback');

Route::post('/rave-pay', 'FlutterwaveController@initialize')->name('rave.pay');
Route::get('/rave/callback', 'FlutterwaveController@callback')->name('rave.callback');

Route::post('paytm-payment', 'PaytmController@order')->name('paytm.payment');
Route::post('paytm/callback', 'PaytmController@paymentCallback')->name('paytm.callback');


Route::post('skrill-ipn', 'SkrillPaymentController@ipn')->name('skrill.ipn');
Route::get('skrill-complete', 'SkrillPaymentController@complete')->name('skrill.payment.complete');
Route::get('skrill-cancelled', 'SkrillPaymentController@cancelled')->name('skrill.payment.cancelled');

Route::get('/authorize-pay','AuthorizeNetController@pay')->name('authorize.pay');
Route::any('/dopay/online', 'AuthorizeNetController@handleonlinepay')->name('authorize.dopay.online');

Route::get('mollie-paymnet', 'MollieController@preparePayment')->name('mollie.payment');
Route::get('mollie-payment-success','MollieController@paymentSuccess')->name('mollie.payment.success');

Route::get('instamojo-event', 'InstamojoController@instamojoIndex');
Route::post('instamojo-pay', 'InstamojoController@instamojoPay')->name('instamojo.pay');
Route::get('instamojo-pay-success', 'InstamojoController@instamojoSuccess')->name('instamojo.payment.success');

Route::post('sceurionpay-ipn', 'SecurionPayController@ipn')->name('sceurionpay.ipn');

Route::post('coingate-ipn', 'CoingateController@ipn')->name('coingate.ipn');
Route::get('coingate-failed', 'CoingateController@failed')->name('coingate.failed');
Route::get('coingate-success', 'CoingateController@success')->name('coingate.success');

Route::post('coinbasecommerce-ipn', 'CoinbasecommerceController@ipn')->name('coinbasecommerce.ipn');
Route::get('coinbasecommerce-failed', 'CoinbasecommerceController@failed')->name('coinbasecommerce.failed');

Route::post('twocheckout', 'TwocheckoutController@prepareData')->name('twocheckout.prepareData');
Route::post('twocheckout-ipn', 'TwocheckoutController@ipn')->name('twocheckout.ipn');
Route::get('twocheckout-success', 'TwocheckoutController@success')->name('twocheckout.success');
Route::get('twocheckout-failed', 'TwocheckoutController@failed')->name('twocheckout.failed');
