
<?php $__env->startSection('title',__('Withdraw Details')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table s7__table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Title'); ?></th>
                                <th><b><?php echo app('translator')->get('Detail'); ?></b></td>
                            </tr>
                        </thead>
                        <tbody>

                            <tr>
                                <td><?php echo app('translator')->get('Transaction'); ?>:</td>
                                <td><?php echo e($data->withdraw_id); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo app('translator')->get('Member Name'); ?>:</td>
                                <td><a href="<?php echo e(route('user.view', $data->user->id)); ?>"><?php echo e($data->user->name); ?> </a></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Member Email'); ?>:</td>
                                <td><?php echo e($data->user->email); ?> </td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Amount Of Withdraw'); ?></td>
                                <td><?php echo e($data->amount); ?> <?php echo e($general->currency); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Charge Of Withdraw'); ?></td>
                                <td> <?php echo e($data->charge); ?> <?php echo e($general->currency); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Withdraw Method'); ?></td>
                                <td> <b><?php echo e($data->method_name); ?> </b></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Given Processing Time'); ?></td>
                                <td> <?php echo e($data->processing_time); ?> <?php echo e(__('Days')); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Amount In Method Currency'); ?></td>
                                <td>  <?php echo e($data->method_cur); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Date Of Create'); ?></td>
                                <td>  <?php echo e(date('g:ia \o\n l jS F Y', strtotime($data->created_at))); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Detail'); ?></td>
                                <td> <?php echo e($data->detail); ?></td>
                            </tr>
        
                            <tr>
                                <td><?php echo app('translator')->get('Status'); ?></td>
                                <td>
                                    <?php if($data->status == 0): ?>
                                        <span class="badge bg-warning"><?php echo app('translator')->get('Pending'); ?></span>
                                    <?php elseif($data->status == 1): ?>
                                        <span class="badge bg-success"><?php echo app('translator')->get('Paid'); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><?php echo app('translator')->get('Refunded'); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>

                    </table>
                </div>
                
                <?php if($data->status == 0): ?>
                <div class="col-md-6">
                    <p class="text-danger"><?php echo app('translator')->get('Charge Already taken. Send'); ?> <?php echo e(floatval($data->amount) * floatval($data->method_rate)); ?> <?php echo e($data->method_cur); ?> <?php echo app('translator')->get('To The User'); ?></p>
                    <form method="post" action="<?php echo e(route('withdraw.process', $data->id)); ?>">
                        <?php echo e(csrf_field()); ?>

                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-12">
                                        <strong ><?php echo app('translator')->get('Message'); ?></strong>
                                        <textarea class="form-control" name="message" rows="5"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" name="status" value="1" class="btn btn-sm btn-success pull-left"><?php echo app('translator')->get('Processed'); ?></button>
                                <button type="submit" name="status"  value="3" class="btn btn-sm btn-danger pull-end"><?php echo app('translator')->get('Refund'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                function disableBack() { window.history.forward() }
                window.onload = disableBack();
                window.onpageshow = function(evt) { if (evt.persisted) disableBack() }
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/withdraw/withdraw_detal.blade.php ENDPATH**/ ?>