<?php $__env->startSection('title',__('Transactions')); ?>
<?php $__env->startSection('content'); ?>
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <form action="<?php echo e(route('search.trans.user')); ?>" method="Get">
            <div class="row">
                <div class="form-group col-md-5">
                    <input type="text" class="form-control" placeholder="Search Via Trans ID" name="trans_id" value="<?php echo e(isset(request()->trans_id) ? request()->trans_id: ''); ?>">
                </div>
                <div class="form-group col-md-5">
                    <select class="form-select" name="type">
                        <option <?php echo e(isset(request()->type) && (request()->type == 'All') ? 'selected': ''); ?> value="All"><?php echo e(__('All Transactions')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Invest') ? 'selected': ''); ?> value="Invest"><?php echo e(__('Invest')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Deposit') ? 'selected': ''); ?> value="Deposit"><?php echo e(__('Deposit')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Transfer') ? 'selected': ''); ?> value="Transfer"><?php echo e(__('Transfer')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Income') ? 'selected': ''); ?> value="Income"><?php echo e(__('Income')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Withdraw') ? 'selected': ''); ?> value="Withdraw"><?php echo e(__('Withdraw')); ?></option>
                        <option <?php echo e(isset(request()->type) && (request()->type == 'Referral') ? 'selected': ''); ?> value="Referral"><?php echo e(__('Referral')); ?></option>
                    </select>
                </div>
                <div class="form-group col-md-2">
                    <button type="submit" class="btn btn-base"> <?php echo e(__('Search')); ?></button>
                </div>
            </div>
        </form>
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                    <tr>
                        <th> <?php echo e(__('Trans ID')); ?> </th>
                        <th> <?php echo e(__('Details')); ?> </th>
                        <th> <?php echo e(__('Amount')); ?> </th>
                        <th> <?php echo e(__('Old Balance')); ?> </th>
                        <th> <?php echo e(__('New Balance')); ?> </th>
                        <th> <?php echo e(__('Type')); ?> </th>
                        <th> <?php echo e(__('Time')); ?> </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $trans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($data->trans_id); ?></td>
                        <td><?php echo e(__($data->description)); ?></td>
                        <td><?php echo e($data->amount); ?><?php echo e($general->currency); ?></td>
                        <td><?php echo e($data->old_bal); ?><?php echo e($general->currency); ?></td>
                        <td><?php echo e($data->new_bal); ?><?php echo e($general->currency); ?></td>
                        <td>
                            <?php if($data->status == 0): ?>
                                <span class="badge bg-primary"><?php echo e(__('Invest')); ?></span>
                            <?php elseif($data->status == 1): ?>
                                <span class="badge bg-success"><?php echo e(__('Deposit')); ?></span>
                            <?php elseif($data->status == 2): ?>
                                <span class="badge bg-info"><?php echo e(__('Transfer')); ?></span>
                            <?php elseif($data->status == 3): ?>
                                <span class="badge bg-dark"><?php echo e(__('Withdraw')); ?></span>
                            <?php elseif($data->status == 5): ?>
                            <span class="badge bg-secondary"><?php echo e(__('Referral Commission')); ?></span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark"><?php echo e(__('Income')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(date('d/m/y  h:i A',strtotime($data->created_at))); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    <?php echo e($trans->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/trans-log.blade.php ENDPATH**/ ?>