<?php $__env->startSection('title',__('Deposit Log')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('Serial'); ?></th>
                    <th><?php echo app('translator')->get('Name'); ?></th>
                    <th><?php echo app('translator')->get('Gateway Name'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Charge'); ?></th>
                    <th><?php echo app('translator')->get('USD Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Transaction ID'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key+1); ?></td>
                        <td data-label="Name"><a target="_blank" href="<?php echo e(route('user.view', $deposit->user_id)); ?>"><?php echo e($deposit->user->name); ?></a></td>
                        <td data-label="Email"><?php echo e(($deposit->gateway->main_name)?$deposit->gateway->main_name:$deposit->gateway->name); ?></td>
                        <td data-label="Username"><?php echo e(round($deposit->amount, 8)); ?> <?php echo e($general->currency); ?></td>
                        <td data-label="Mobile"><?php echo e(round($deposit->charge, 8)); ?> <?php echo e($general->currency); ?></td>
                        <td data-label="Balance"><?php echo e(round($deposit->usd_amo, 8)); ?> USD</td>
                        <td>
                        <?php if(isset($deposit->deposit_request_table) && !is_null($deposit->deposit_request_table)): ?>
                            <?php if($deposit->deposit_request_table->accepted == 0): ?>
                                <span class="badge bg-warning"><?php echo app('translator')->get('pending'); ?></span>
                            <?php elseif($deposit->deposit_request_table->accepted == 1): ?>
                                <span class="badge bg-success"><?php echo app('translator')->get('approved'); ?></span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo app('translator')->get('rejected'); ?></span>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="badge bg-info"><?php echo e(($deposit->status==0)?'incomplete':'complete'); ?></span>
                        <?php endif; ?>
                        </td>
                        <td  data-label="Details"><?php echo e($deposit->trx); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($deposits->links('pagination::bootstrap-4')); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/deposit/deposits.blade.php ENDPATH**/ ?>