<?php $__env->startSection('title',__('Plan')); ?>
<?php $__env->startSection('content'); ?>
<div class="pricing-area pd-top-120 pd-bottom-90">
    <div class="container">
        <nav class="text-center mb-4">
            <ul class="nav nav-tabs transaction-nav-tab d-inline-flex" id="myTab" role="tablist">
                <?php if(count($roi_plans)): ?>
                <li class="nav-item m-1" role="presentation">
                    <button class="nav-link active" id="nav-monthly-tab" data-bs-toggle="tab" data-bs-target="#nav-roi" type="button" role="tab" aria-controls="nav-roi" aria-selected="true"> <?php echo e(__('ROI Investment')); ?> </button>
                </li>
                <?php endif; ?>
                <?php if(count($fixed_plans)): ?>
                <li class="nav-item m-1" role="presentation">
                    <button class="nav-link" id="nav-yearly-tab" data-bs-toggle="tab" data-bs-target="#nav-fixed" type="button" role="tab" aria-controls="nav-fixed" aria-selected="false"><?php echo e(__('Fixed Investment')); ?></button>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="nav-roi" role="tabpanel" aria-labelledby="nav-monthly-tab">
                <div class="row">
                    <?php $__currentLoopData = $roi_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-pricing-inner price-active">
                            <div class="icon text-end">
                                <img src="<?php echo e(asset('public/frontend/deepblack/img/icon/19.svg')); ?>" alt="img">
                            </div>
                            <h5><?php echo e(__($data->name)); ?></h5>
                            <ul>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('Minimum Deposit')); ?> <?php echo e($data->min_amount); ?> <?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('Maximum Deposit')); ?> <?php echo e($data->max_amount); ?> <?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('ROI Action')); ?> <?php echo e($data->action); ?> <?php echo e(__('TIMES')); ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                    <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                                <li><i class="fa fa-chevron-right"></i> 
                                    <?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?>

                                    <?php echo e(trans($getTime->name)); ?>

                                </li>
                            </ul>
                            <a class="btn btn-base w-100 investRoi" data-all="<?php echo e($data); ?>" data-route="<?php echo e(route('purchase.plan',$data->id)); ?>" href="#addModal" data-bs-toggle="modal"><?php echo e(__('Buy Now')); ?></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="nav-fixed" role="tabpanel" aria-labelledby="nav-yearly-tab">
                <div class="row">
                    <?php $__currentLoopData = $fixed_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $getTime = \App\Models\ManageTime::where('time', $data->period)->first();
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-pricing-inner price-active">
                            <div class="icon text-end">
                                <img src="<?php echo e(asset('public/frontend/deepblack/img/icon/19.svg')); ?>" alt="img">
                            </div>
                            <h5><?php echo e(__($data->name)); ?></h5>
                            <ul>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('Deposit')); ?> <?php echo e($data->fixed_amount); ?><?php echo e($general->currency); ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('ROI Action Lifetime TIMES')); ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e(__('Capital Return')); ?> <?php if($data->capital_back_status == 0): ?> 
                                    <span class="badge bg bg-danger"><?php echo app('translator')->get('Off'); ?></span> <?php else: ?> <span class="badge bg bg-success"><?php echo app('translator')->get('On'); ?></span> <?php endif; ?></li>
                                <li><i class="fa fa-chevron-right"></i> <?php echo e($data->percent); ?>% <?php echo e(__('Payback')); ?>

                                    <?php echo e(trans($getTime->name)); ?>

                                </li> 
                            </ul>
                            <a class="btn btn-base w-100 investFixed" href="#addModalTwo" data-bs-toggle="modal" data-all="<?php echo e($data); ?>"  data-route="<?php echo e(route('purchase.plan',$data->id)); ?>"><?php echo e(__('Buy Now')); ?></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white roiTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlan" action="" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <h6 class="text-success text-center totalGetAmount"></h6>
                <p class="text-primary text-center roiMsg"></p>
                <div class="form-row">
                    <div class="input-group col-md-12">
                        <input type="text" class="form-control" id="investAmount" name="invest_amount" placeholder="<?php echo e(__('Put Amount for invest')); ?>" autocomplete="off">
                        <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                    </div>
                </div>
                <p class="text-danger text-center roiMinMax"></p>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success submitBtn"><?php echo e(__('Submit')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>


<div class="modal fade" id="addModalTwo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-white fixTitle"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="purPlanTwo" action="" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <h6 class="text-danger text-center tAmountFix"></h6>
                <h5 class="text-success text-center totalGetAmountFix"></h5>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><?php echo e(__('Submit')); ?></button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </form>
      </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
        $(document).ready(function () {
            $('.submitBtn').css('display','none');
            $('.investFixed').on('click',function () {
                $('#purPlanTwo').attr('action',$(this).data('route'));
                let retuenPerFix = $(this).data('all')['percent'];
                let amtFix = $(this).data('all')['fixed_amount'];
                $('.fixTitle').text($(this).data('all')['name']);
                $('.tAmountFix').text(amtFix+' <?php echo e($general->currency); ?> will deduct from your balance');
                $('.totalGetAmountFix').text('You will get '+retuenPerFix+'% of your Invest for Lifetime');
            });

            $('.investRoi').on('click',function () {
                $('#purPlan').attr('action',$(this).data('route'));
                $('#investAmount').val('');
                getBlank();
                let minAmount = $(this).data('all')['min_amount'];
                let maxAmount = $(this).data('all')['max_amount'];
                let retuenPer = $(this).data('all')['percent'];
                let retuenAction = $(this).data('all')['action'];
                $('.roiTitle').text($(this).data('all')['name']);
                $('.roiMinMax').text('Minimum '+minAmount+' <?php echo e($general->currency); ?> - Maximum '+maxAmount+'<?php echo e($general->currency); ?>');
                $('#investAmount').on('keyup',function () {
                    let invAmount = this.value;
                    if ((parseFloat(invAmount) >= parseFloat(minAmount)) && (parseFloat(invAmount) <= parseFloat(maxAmount))) {
                        let returnAmt = (parseFloat(invAmount)*parseFloat(retuenPer))/100;
                        let totalGetAmount = parseFloat(returnAmt)*parseFloat(retuenAction);
                        $('.roiMsg').text('You will get '+returnAmt+' <?php echo e($general->currency); ?> for '+retuenAction+' times');
                        $('.totalGetAmount').text('You will get total '+totalGetAmount+' <?php echo e($general->currency); ?> after complete ROI');
                        $('.submitBtn').css('display','block');
                    }else {
                        $('.submitBtn').css('display','none');
                        getBlank();
                    }
                })
            });
            function getBlank() {
                $('.roiMsg').text('');
                $('.totalGetAmount').text('');
            }
        });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/invest/plan.blade.php ENDPATH**/ ?>