
<?php $__env->startSection('title',__('User Management')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card mb-3">
        <div class="card-header">
            <div class="card-title uppercase bold"><i class="fa fa-search"></i> <?php echo app('translator')->get('Search Users'); ?></div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <form class="form-horizontal" method="GET" action="<?php echo e(route('username.search')); ?>">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" name="username" required placeholder="<?php echo app('translator')->get('Search By Name'); ?>" aria-describedby="basic-addon2">
                        <button class="btn btn-outline-primary" type="submit"><?php echo app('translator')->get('Search'); ?></button>
                    </div>
                    </form>
                </div>

                <div class="col-md-6">
                    <form class="form-horizontal" method="GET" action="<?php echo e(route('email.search')); ?>">
                        <div class="input-group mb-3">
                            <input type="email" class="form-control" name="email"  placeholder="<?php echo app('translator')->get('Search By Email'); ?>" aria-describedby="basic-addon1">
                            <button class="btn btn-outline-primary" type="submit"><?php echo app('translator')->get('Search'); ?></button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="card-title"><i class="fa fa-user"></i> <?php echo app('translator')->get('User List'); ?></div>
        </div>
        <div class="card-body p-0">
            <table class="table table-sm s7__table">
                <thead>
                <tr>
                    <th> <?php echo app('translator')->get('Sl'); ?></th>
                    <th> <?php echo app('translator')->get('Name'); ?> </th>
                    <th><?php echo app('translator')->get('Email'); ?></th>
                    <th><?php echo app('translator')->get('Mobile'); ?></th>
                    <th> <?php echo app('translator')->get('Balance'); ?></th>
                    <th> <?php echo app('translator')->get('Action'); ?> </th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key+1); ?></td>
                        <td><?php echo e($data->name); ?></td>
                        <td><b><?php echo e($data->email); ?></b></td>
                        <td><?php echo e($data->mobile); ?></td>
                        <td><?php echo e(round($data->balance,8)); ?><?php echo e($general->currency); ?></td>
                        <td>
                            <a class="btn s7__btn-primary s7__bg-base btn-sm" href="<?php echo e(route('user.view', $data->id)); ?>"><i class="fa fa-eye"></i>  <?php echo app('translator')->get('View'); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($user->links('pagination::bootstrap-4')); ?> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/user/index.blade.php ENDPATH**/ ?>