
<?php $__env->startSection('title',__('Schedule')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Schedule List'); ?> <a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a> </h4>
        </div>

        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('Name'); ?></th>
                    <th><?php echo app('translator')->get('Duration'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $manageTime; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($data->name); ?></td>
                    <td><?php echo app('translator')->get('Time'); ?>: <?php echo app('translator')->get($data->time); ?> <?php echo app('translator')->get('Hours'); ?></td>
                    <td>
                        <a href="#editModal<?php echo e($data->id); ?>" data-bs-toggle="modal" class="btn s7__btn-primary s7__bg-base btn-sm editBtn"><?php echo app('translator')->get('View/Edit'); ?></a>
                    </td>
                </tr>
                <div id="editModal<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo app('translator')->get('Edit Schedule'); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form id="Form" action="<?php echo e(route('update.schedule',$data->id)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="modal-body">
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label><?php echo app('translator')->get('Name'); ?></label>
                                            <input type="text" name="name" value="<?php echo e($data->name); ?>" class="edit-name form-control form-control-lg">
                                        </div>
                
                                        <div class="form-group">
                                            <label><?php echo app('translator')->get('Time'); ?></label>
                                            <div class="input-group mb-3">
                                                <input type="text" name="time" value="<?php echo e($data->time); ?>"
                                                class="edit-time form-control form-control-lg">
                                                <span class="input-group-text"><?php echo e(trans('Hour')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add Social'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form  role="form" action="<?php echo e(route('store.schedule')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                       <div class="form-row">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Name'); ?></label>
                                <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-control form-control-lg">
                            </div>

                            <div class="form-group">
                                <label><?php echo app('translator')->get('Time'); ?></label>
                                <div class="input-group mb-3">
                                    <input type="text" name="time" value="<?php echo e(old('time')); ?>"
                                        class="form-control form-control-lg">
                                        <span class="input-group-text"><?php echo e(trans('Hour')); ?></span>
                                </div>
                            </div>
                       </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/plan/schedule.blade.php ENDPATH**/ ?>