<?php $__env->startSection('title',__('Deposit Log')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4>
                <?php if(request()->path() == 'admin/deposit/acceptedRequests'): ?>
                    <?php echo app('translator')->get('Accepted'); ?>
                <?php elseif(request()->path() == 'admin/deposit/rejectedRequests'): ?>
                    <?php echo app('translator')->get('Rejected'); ?>
                <?php elseif(request()->path() == 'admin/deposit/pending'): ?>
                    <?php echo app('translator')->get('Pending'); ?>
                <?php endif; ?>
                <?php echo app('translator')->get('Deposit Request'); ?>
            </h4>
        </div>

        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table s7__table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo app('translator')->get('Name'); ?></th>
                            <th><?php echo app('translator')->get('Gateway Name'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Charge'); ?></th>
                            <th><?php echo app('translator')->get('Receipt'); ?></th>
                            <?php if(request()->path() != 'admin/deposit/acceptedRequests' && request()->path() != 'admin/deposit/rejectedRequests'): ?>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $i = 0;
                    ?>
                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-label="Name"><?php echo e(++$i); ?></td>
                            <td data-label="Username"><a target="_blank" href="<?php echo e(route('user.view', $deposit->user_id)); ?>"><?php echo e($deposit->user->name); ?></a></td>
                            <td data-label="Email"><?php echo e($deposit->gateway->name); ?></td>
                            <td data-label="Mobile"><?php echo e(round($deposit->amount, 8)); ?> <?php echo e($general->currency); ?></td>
                            <td data-label="Balance"><?php echo e(round($deposit->charge, 8)); ?> <?php echo e($general->currency); ?></td>
                            <td>
                                <button type="button" class="btn s7__btn-primary s7__bg-base showImageInModal" data-depID="<?php echo e($deposit->id); ?>" ><i class="fa fa-eye"></i> <?php echo app('translator')->get('Show'); ?></button>
                            </td>
                            <?php if(request()->path() != 'admin/deposit/acceptedRequests' && request()->path() != 'admin/deposit/rejectedRequests'): ?>
                                <td data-label="Details">
                                    <form class="inline-block deposit_rec mb-1" action="<?php echo e(route('admin.deposit.accept')); ?>" method="post">
                                        <?php echo e(csrf_field()); ?>

                                        <input type="hidden" name="gid" value="<?php echo e($deposit->gateway->id); ?>">
                                        <input type="hidden" name="dID" value="<?php echo e($deposit->id); ?>">
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="fa fa-check"></i>  <?php echo app('translator')->get('Accept'); ?>
                                        </button>
                                    </form>
                                    <form class="inline-block deposit_rec" action="<?php echo e(route('admin.deposit.rejectReq')); ?>" method="post">
                                        <?php echo e(csrf_field()); ?>

                                        <input type="hidden" name="dID" value="<?php echo e($deposit->id); ?>">
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fa fa-times"></i> <?php echo app('translator')->get('Reject'); ?>
                                        </button>
                                    </form>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                    <?php echo e($deposits->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade showImageModal" id="showImageModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('Receipt Image'); ?> <span id="modalHeader"></span></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <img class="width-100" id="adImage" src="" alt="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function(){
                $('.showImageInModal').on('click',function(){
                    $.get(
                        '<?php echo e(route('admin.deposit.showReceipt')); ?>',
                        {
                            dID: $(this).attr('data-depID'),
                        },
                        function(data) {
                            $('.showImageModal').modal('show');
                            document.getElementById('adImage').src = '<?php echo e(asset('public/images/receipt_img')); ?>'+'/'+data.r_img;
                        }
                    );
                });
            });
    })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/deposit/requests.blade.php ENDPATH**/ ?>