<?php $__env->startSection('title',__('Invest History')); ?>
<?php $__env->startSection('content'); ?>
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table">
                <thead>
                    <tr>
                        <th> <?php echo e(__('Package')); ?> </th>
                        <th> <?php echo e(__('Type')); ?> </th>
                        <th> <?php echo e(__('Invest Amount')); ?> </th>
                        <th> <?php echo e(__('Payable')); ?> </th>
                        <th> <?php echo e(__('Already Return')); ?> </th>
                        <th> <?php echo e(__('Next Return Time')); ?> </th>
                        <th> <?php echo e(__('Status')); ?> </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(__($data->plan_name)); ?></td>
                        <td>
                            <?php switch($data->get_period):
                                case (1): ?>
                                <?php echo e(__('Hourly')); ?>

                                <?php break; ?>
                                <?php case (24): ?>
                                <?php echo e(__('Daily')); ?>   <?php break; ?>
                                <?php case (168): ?>
                                <?php echo e(__('Weekly')); ?>   <?php break; ?>
                                <?php case (720): ?>
                                <?php echo e(__('Monthly')); ?>   <?php break; ?>
                                <?php case (2880): ?>
                                <?php echo e(__('Quarterly')); ?>   <?php break; ?>
                                <?php case (8640): ?>
                                <?php echo e(__('Yearly')); ?>   <?php break; ?>
                            <?php endswitch; ?>
                        </td>
                        <td><?php echo e($data->invest_amount); ?>  <?php echo e($general->currency); ?></td>
                        <td><?php echo e($data->get_percent); ?>%/<?php echo e(is_null($data->get_action) ? 'Lifetime': $data->get_action.' Times'); ?>  </td>
                        <td><?php echo e($data->took_action); ?> <?php echo e(__('TIMES')); ?></td>
                        <td><?php echo e(date('d/m/y  h:i A',strtotime($data->next_time))); ?></td>
                        <td>
                            <?php if($data->status == 0): ?>
                                <span class="badge bg-primary"><?php echo e(__('Continue')); ?></span>
                            <?php else: ?>
                                <span class="badge bg-success"><?php echo e(__('Complete')); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    <?php echo e($plans->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/invest/log.blade.php ENDPATH**/ ?>