
<?php $__env->startSection('title',__('Withdraw')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Withdraw Payment Methods'); ?> <a href="#addModal" data-bs-toggle="modal" class="btn btn-success btn-sm float-end"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?></a> </h4>
        </div>

        <div class="card-body">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('Method Name'); ?></th>
                    <th><?php echo app('translator')->get('Method Logo'); ?></th>
                    <th><?php echo app('translator')->get('Min Amount'); ?></th>
                    <th><?php echo app('translator')->get('Max Amount'); ?></th>
                    <th><?php echo app('translator')->get('Fix Charge'); ?></th>
                    <th><?php echo app('translator')->get('Percent of Charge'); ?></th>
                    <th><?php echo app('translator')->get('Rate'); ?></th>
                    <th><?php echo app('translator')->get('Processing Day'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $withdraw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="row1">
                        <td> <b><?php echo e($data->name); ?></b></td>
                        <td> <img width="50" src="<?php echo e(asset('public/images/withdraw_methods/'.$data->image)); ?>"></td>
                        <td> <?php echo e($data->min_amo); ?> </td>
                        <td> <?php echo e($data->max_amo); ?> </td>
                        <td> <?php echo e($data->chargefx); ?> <?php echo e($general->currency); ?></td>
                        <td> <?php echo e($data->chargepc); ?> %</td>
                        <td> <?php echo e($data->rate); ?></td>
                        <td> <?php echo e($data->processing_day); ?> <?php echo app('translator')->get('Days'); ?></td>
                        <td>
                            <?php if($data->status == 1): ?>
                                <span class="badge bg-success"><?php echo app('translator')->get('Active'); ?></span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo app('translator')->get('Inactive'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><a class="btn s7__btn-primary s7__bg-base btn-sm" data-bs-toggle="modal" href="#editModal<?php echo e($data->id); ?>"><?php echo app('translator')->get('Edit'); ?> </a></td>
                    </tr>

                    <div id="editModal<?php echo e($data->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo app('translator')->get('Edit'); ?> <?php echo e($data->name); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form role="form" method="post" action="<?php echo e(route('update.withdraw.method', $data->id)); ?>" enctype="multipart/form-data">
                                    <div class="modal-body">
                                        <?php echo e(csrf_field()); ?>

                                        <?php echo e(method_field('put')); ?>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Payment Method Image'); ?></label>
                                            <input class="form-control" type="file" name="image">
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Payment Method Name'); ?></label>
                                            <input class="form-control text-capitalize" value="<?php echo e($data->name); ?>" type="text" required name="name">
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Minimum Amount For Withdraw'); ?> ( <?php echo e($general->currency); ?> )</label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize" value="<?php echo e($data->min_amo); ?>" type="number" required name="min_amo">
                                                <span class="input-group-text"> <?php echo e($general->currency); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Maximum Amount For Withdraw'); ?></label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize"  value="<?php echo e($data->max_amo); ?>" type="number" required name="max_amo">
                                                <span class="input-group-text"> <?php echo e($general->currency); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Fixed Charge For With Draw'); ?> ( <?php echo e($general->currency); ?> )</label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize"  value="<?php echo e($data->chargefx); ?>"  type="text" required name="chargefx">
                                                <span class="input-group-text"> <?php echo e($general->currency); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Charge Percentage'); ?> ( <?php echo e($general->currency); ?> )</label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize" value="<?php echo e($data->chargepc); ?>"  type="text" required name="chargepc">
                                                <span class="input-group-text"> %</span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Rate for 1'); ?> <?php echo e($data->currency); ?></label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize" placeholder="Rate" value="<?php echo e($data->rate); ?>" type="text" required name="rate">
                                                <span class="input-group-text"> <?php echo e($general->currency); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Method Currency'); ?></label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize" value="<?php echo e($data->currency); ?>" placeholder="Currency" type="text" required name="currency">
                                                <span class="input-group-text"><?php echo e($data->currency); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Payback Days'); ?></label>
                                            <div class="input-group">
                                                <input class="form-control text-capitalize" placeholder="Day" value="<?php echo e($data->processing_day); ?>" type="text" required name="processing_day">
                                                <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12 mb-2">
                                            <label class="form-label"><?php echo app('translator')->get('Status'); ?></label>
                                            <select class="form-select" name="status">
                                                <option  <?php if($data->status == 1): ?> selected <?php else: ?>   <?php endif; ?> value="1"><?php echo app('translator')->get('Active'); ?></option>
                                                <option <?php if($data->status == 0): ?> selected <?php else: ?>   <?php endif; ?> value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <div class="col-md-12">
                                            <button type="button" data-bs-dismiss="modal" class="btn btn-sm btn-danger"><?php echo app('translator')->get('Cancel'); ?></button>
                                            <button type="submit" class="btn btn-sm btn-success"> <?php echo app('translator')->get('Update'); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <div id="addModal" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add Gateway'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class="form-horizontal" role="form" method="post" action="<?php echo e(route('store.withdraw.method')); ?>" enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo e(csrf_field()); ?>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Payment Method Image'); ?></label>
                            <input class="form-control"  type="file" required name="image">
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Payment Method Name'); ?></label>
                            <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Method Name'); ?>" type="text" required name="name">
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Minimum Amount For Withdraw'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Minimum Amount'); ?>" type="number" required name="min_amo">
                                <span class="input-group-text"><?php echo e($general->currency); ?></span>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Maximum Amount For Withdraw'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Maximum Amount'); ?>" type="number" required name="max_amo">
                                <span class="input-group-text"><?php echo e($general->currency); ?></span>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Fixed Charge For With Draw'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Charge'); ?>" type="text" required name="chargefx">
                                <span class="input-group-text"><?php echo e($general->currency); ?></span>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Charge Percentage'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Charge Percentage'); ?>" type="text" required name="chargepc">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Rate for 1 Method Currency'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Rate'); ?>" type="text" required name="rate">
                                <span class="input-group-text"><?php echo app('translator')->get('Currency'); ?></span>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Method Currency'); ?></label>
                            <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Currency'); ?>" type="text" required name="currency">
                        </div>

                        <div class="form-group col-md-12 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Payback Days'); ?></label>
                            <div class="input-group">
                                <input class="form-control text-capitalize" placeholder="<?php echo app('translator')->get('Day'); ?>" type="text" required name="processing_day">
                                <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                            </div>
                        </div>
                    </div>


                    <div class="modal-footer">
                        <button type="button" data-bs-dismiss="modal" class="btn btn-sm btn-danger"><?php echo app('translator')->get('Cancel'); ?></button>
                        <button type="submit" class="btn btn-sm btn-success"> <?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/withdraw/add_withdraw_method.blade.php ENDPATH**/ ?>