<?php $__env->startSection('title',__('Transaction')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card mb-3">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Search from log'); ?></h4>
        </div>
        <div class="card-body">
            <form class="form-cont" action="<?php echo e(route('search.trans.admin')); ?>" method="Get">
                <div class="row">
                    <div class="col-md-3">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search Via Trans ID" name="trans_id" value="<?php echo e(isset(request()->trans_id) ? request()->trans_id: ''); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search Via User's name" name="user" value="<?php echo e(isset(request()->user) ? request()->user: ''); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="input-group">
                            <select class="form-select" name="type">
                                <option <?php echo e(isset(request()->type) && (request()->type == 'All') ? 'selected': ''); ?> value="All"><?php echo app('translator')->get('All'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Invest') ? 'selected': ''); ?> value="Invest"><?php echo app('translator')->get('Invest'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Deposit') ? 'selected': ''); ?> value="Deposit"><?php echo app('translator')->get('Deposit'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Transfer') ? 'selected': ''); ?> value="Transfer"><?php echo app('translator')->get('Transfer'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Income') ? 'selected': ''); ?> value="Income"><?php echo app('translator')->get('Income'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Withdraw') ? 'selected': ''); ?> value="Withdraw"><?php echo app('translator')->get('Withdraw'); ?></option>
                                <option <?php echo e(isset(request()->type) && (request()->type == 'Referral') ? 'selected': ''); ?> value="Referral"><?php echo e(__('Referral')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-primary btn-block"> <i class="fa fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th> <?php echo app('translator')->get('Trans ID'); ?> </th>
                    <th> <?php echo app('translator')->get('User'); ?> </th>
                    <th> <?php echo app('translator')->get('Details'); ?> </th>
                    <th> <?php echo app('translator')->get('Amount'); ?> </th>
                    <th> <?php echo app('translator')->get('Old Balance'); ?> </th>
                    <th> <?php echo app('translator')->get('New Balance'); ?> </th>
                    <th> <?php echo app('translator')->get('Type'); ?> </th>
                    <th> <?php echo app('translator')->get('Time'); ?> </th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $trans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($data->trans_id); ?></td>
                        <td><a class="title_a" href="<?php echo e(route('user.view', $data->user->id)); ?>"><?php echo e($data->user->name); ?></a></td>
                        <td><?php echo e($data->description); ?></td>
                        <td><?php echo e(round($data->amount,8)); ?> <?php echo e($general->currency); ?></td>
                        <td><?php echo e(round($data->old_bal,8)); ?> <?php echo e($general->currency); ?></td>
                        <td><?php echo e(round($data->new_bal,8)); ?> <?php echo e($general->currency); ?></td>
                        <td>
                            <?php if($data->status == 0): ?>
                                <span class="badge bg-primary"><?php echo app('translator')->get('Invest'); ?></span>
                            <?php elseif($data->status == 1): ?>
                                <span class="badge bg-success"><?php echo app('translator')->get('Deposit'); ?></span>
                            <?php elseif($data->status == 2): ?>
                                <span class="badge bg-info"><?php echo app('translator')->get('Transfer'); ?></span>
                            <?php elseif($data->status == 3): ?>
                                <span class="badge bg-dark"><?php echo app('translator')->get('Withdraw'); ?></span>
                            <?php elseif($data->status == 5): ?>
                                <span class="badge bg-secondary"><?php echo e(__('Referral Commission')); ?></span>
                            <?php else: ?>
                                <span class="badge bg-warning"><?php echo app('translator')->get('Income'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(date('d/m/y  h:i A',strtotime($data->created_at))); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($trans->links('pagination::bootstrap-4')); ?> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/trans-log.blade.php ENDPATH**/ ?>