<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title><?php echo e($general->web_name); ?> | <?php echo $__env->yieldContent('title'); ?></title>
        <link rel="icon" type="image/png" href="<?php echo e(asset('public/images/logo/favicon.png')); ?>" sizes="16x16" />
        <?php echo $__env->make('admin.layouts.partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('style'); ?>
    </head>
    <body>

        <div class="preloader">
            <div class="preloader-icon-img">
                <img src="<?php echo e(asset('public/backend/images/spinner.svg')); ?>" alt="preloader spinner">
            </div>
        </div>
        
        <?php echo $__env->make('admin.layouts.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-area">
            <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <main class="s7__main">
                <div class="s7__page-nav">
                    <div class="left">
                      <h6 class="title text-uppercase"><?php echo e($page_title); ?></h6>
                    </div>
                    <div class="right">
                      <ul>
                        <li><a href="<?php echo e(route('admin.home')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                        <li><?php echo e($page_title); ?></li>
                      </ul>
                    </div>
                  </div>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
            
        </div>

        <?php echo $__env->make('admin.layouts.partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('script'); ?>
    </body>
</html><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/layouts/master.blade.php ENDPATH**/ ?>