<?php $__env->startSection('title',__('Gateway')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <h4 class="card-header"><?php echo e(__('Gateway List')); ?>

            <button type="button" class="btn btn-success float-end btn-sm" data-bs-toggle="modal" data-bs-target="#addModal">
                <i class="fa fa-plus"></i> <?php echo app('translator')->get('Add Gateway'); ?>
            </button>
        </h4>
        <div class="card-body p-0">
            <table class="table table-sm s7__table">
                <thead>
                <tr>
                    <th><?php echo app('translator')->get('SL'); ?></th>
                    <th><?php echo app('translator')->get('Gateway'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(++$k); ?></td>
                        <td><?php echo e($gateway->name); ?></td>
                        <td>
                            <?php if($gateway->status == 1): ?>
                                <span class="badge bg-success"><?php echo app('translator')->get('Active'); ?></span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo app('translator')->get('Inactive'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <button class="btn s7__btn-primary s7__bg-base btn-sm"
                                    data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($gateway->id); ?>"
                                    data-act="Edit">
                            <?php echo e(__('Edit')); ?>

                            </button>
                        </td>
                    </tr>

                    <div class="modal fade editModal" id="editModal<?php echo e($gateway->id); ?>" tabindex="-1"
                            role="dialog">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h4 class="modal-title" id="myModalLabel"><?php echo app('translator')->get('Edit'); ?>
                                        <strong><?php echo e($gateway->name); ?></strong></h4>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form method="post" action="<?php echo e(route('update.gateway')); ?>" enctype="multipart/form-data">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="modal-body">
                                        <input class="form-control" value="<?php echo e($gateway->id); ?>" type="hidden" name="id">
                                        <input class="form-control abir_id" value="<?php echo e($gateway->id); ?>" type="hidden" name="id">

                                        <div class="form-group">
                                            <label class="form-label"><?php echo app('translator')->get('Gateway Image'); ?></label>
                                            <input type="file" id="file-input" class="form-control" name="image">
                                            <div class="row mt-2">
                                                <div class="col-md-12">
                                                    <div id='img_contain'>
                                                        <img id="image-preview" class="img-fluid" align='middle' src="<?php echo e(asset('public/images/gateway/'.$gateway->image)); ?>" alt="your image" title=''/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <strong><?php echo app('translator')->get('Name of Gateway'); ?></strong>
                                                    <input type="text" value="<?php echo e($gateway->name); ?>" class="form-control" id="name" name="name" >
                                                </div>
                                                <div class="col-md-6">
                                                    <strong><?php echo app('translator')->get('Rate'); ?></strong>
                                                    <div class="input-group mb-3">
                                                        <span class="input-group-text">1 USD=</span>
                                                        <input name="rate" value="<?php echo e($gateway->rate); ?>" type="text" class="form-control">
                                                        <span class="input-group-text"><?php echo e($general->currency); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <div class="card mb-3 max-width-18rem">
                                                    <div class="card-header bg-primary text-white"><strong><?php echo e(__('Deposit Limit')); ?></strong></div>
                                                    <div class="card-body">
                                                        <strong><?php echo e(__('Minimum Amount')); ?></strong>
                                                        <div class="input-group mb-3">
                                                            <input value="<?php echo e($gateway->minimum_deposit_amount); ?>" type="text" name="minimum_deposit_amount" class="form-control" >
                                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                                        </div>
                                                        <strong><?php echo e(__('Maximum Amount')); ?></strong>
                                                        <div class="input-group mb-3">
                                                            <input value="<?php echo e($gateway->maximum_deposit_amount); ?>" type="text" name="maximum_deposit_amount" class="form-control">
                                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card mb-3 max-width-18rem">
                                                    <div class="card-header bg-primary text-white"><strong><?php echo app('translator')->get('Deposit Charge'); ?></strong></div>
                                                    <div class="card-body">
                                                        <strong><?php echo app('translator')->get('Fixed Charge'); ?></strong>
                                                        <div class="input-group mb-3">
                                                            <input value="<?php echo e($gateway->fixed_charge); ?>" type="text" name="fixed_charge" class="form-control" >
                                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                                        </div>
                                                        <strong><?php echo app('translator')->get('Charge in Percentage'); ?></strong>
                                                        <div class="input-group mb-3">
                                                            <input value="<?php echo e($gateway->percentage_charge); ?>" type="text" name="percentage_charge" class="form-control">
                                                            <span class="input-group-text" id="basic-addon2">%</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <?php if($gateway->id > 69): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYMENT DETAILS'); ?></strong>
                                                <textarea class="form-control" name="gateway_key_four" rows="3" cols="80"><?php echo $gateway->gateway_key_four; ?></textarea>
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==1): ?>
                                            <div class="form-group mb-2">
                                                <strong><?php echo app('translator')->get('PAYPAL API USERNAME'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group mb-2">
                                                <strong><?php echo app('translator')->get('PAYPAL API PASSWORD'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group mb-2">
                                                <strong><?php echo app('translator')->get('PAYPAL API SECRET'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==2): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('COINPAYMENT MERCHANT ID'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                                <div class="form-group">
                                                <strong><?php echo app('translator')->get('COINPAYMENT SECRET'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                        <?php endif; ?>

                                        <?php if($gateway->id==3): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('STRIPE SECRET'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('STRIPE KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==4): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYFAST MERCHANT ID'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYFAST MERCHANT KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==5): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('Callback URL'); ?></strong>
                                                <input type="text" value="<?php echo e(url('/')); ?>/paystack-payment/callback" class="form-control" readonly>
                                                <p class="text-success"><small><?php echo e(__('Copy this link & save on your paystack portal (API Keys & Webhooks)')); ?></small></p>
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYSTACK PUBLIC KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYSTACK SECRET KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('MERCHANT EMAIL'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==6): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('FLW PUBLIC KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('FLW SECRET KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('FLW SECRET HASH'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==7): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYTM MERCHANT ID'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('PAYTM MERCHANT KEY'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==8): ?>
                                            <div class="form-group">
                                                <strong><?php echo app('translator')->get('Skrill EMAIL'); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==9): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('MERCHANT LOGIN ID')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>

                                            <div class="form-group">
                                                <strong><?php echo e(__('MERCHANT TRANSACTION KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==10): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('API KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==11): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('API KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo e(__('AUTH TOKEN')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo e(__('API URL')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_three); ?>" class="form-control" id="gateway_key_three" name="gateway_key_three" >
                                        <?php endif; ?>

                                        <?php if($gateway->id==12): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('PUBLIC KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo e(__('SECRET KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==13): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('API KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==14): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('API KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo e(__('SECRET KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>

                                        <?php if($gateway->id==15): ?>
                                            <div class="form-group">
                                                <strong><?php echo e(__('PUBLISHABLE KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_one); ?>" class="form-control" id="gateway_key_one" name="gateway_key_one" >
                                            </div>
                                            <div class="form-group">
                                                <strong><?php echo e(__('PRIVATE KEY')); ?></strong>
                                                <input type="text" value="<?php echo e($gateway->gateway_key_two); ?>" class="form-control" id="gateway_key_two" name="gateway_key_two" >
                                            </div>
                                        <?php endif; ?>


                                        <div class="form-group">
                                            <strong><?php echo e(__('Status')); ?></strong>
                                            <select class="form-select" name="status">
                                                <option value="1" <?php echo e($gateway->status==1?'selected':''); ?>><?php echo app('translator')->get('Active'); ?></option>
                                                <option value="0" <?php echo e($gateway->status==0?'selected':''); ?>><?php echo app('translator')->get('Inactive'); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class=" btn btn-danger" data-bs-dismiss="modal" aria-hidden="true"><?php echo app('translator')->get('Close'); ?></button>
                                        <button type="submit" class="btn btn-success "><?php echo app('translator')->get('Save Changes'); ?></button>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tbody>
            </table>
        </div>
    </div>

<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form class="" action="<?php echo e(route('store.gateway')); ?>" method="post" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('Add Payment Gateway'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?php echo e(csrf_field()); ?>


                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <strong><?php echo app('translator')->get('Gateway Image'); ?></strong>
                                <input type="file" value="" class="form-control" name="image" required>
                            </div>

                            <div class="col-md-6">
                                <strong><?php echo app('translator')->get('Name of Gateway'); ?></strong>
                                <input type="text" value="" class="form-control" id="name" name="name" >
                            </div>
                            <div class="col-md-6">
                                <strong><?php echo app('translator')->get('Rate'); ?></strong>
                                <div class="input-group mb-3">
                                        <span class="input-group-text">1 USD = </span>
                                    <input name="rate" type="text" class="form-control">
                                        <span class="input-group-text"> <?php echo e($general->currency); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="card mb-3 max-width-18rem">
                                <div class="card-header bg-primary text-white"><strong><?php echo app('translator')->get('Deposit Limit'); ?></strong></div>
                                <div class="card-body">
                                    <strong><?php echo app('translator')->get('Minimum Amount'); ?></strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="minimum_deposit_amount" class="form-control" >
                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                    <strong><?php echo app('translator')->get('Maximum Amount'); ?></strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="maximum_deposit_amount" class="form-control">
                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-3 max-width-18rem">
                                <div class="card-header bg-primary text-white"><strong><?php echo app('translator')->get('Deposit Charge'); ?></strong></div>
                                <div class="card-body">
                                    <strong><?php echo app('translator')->get('Fixed Charge'); ?></strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="fixed_charge" class="form-control" placeholder="">
                                            <span class="input-group-text" id="basic-addon2"><?php echo e($general->currency); ?></span>
                                    </div>
                                    <strong><?php echo app('translator')->get('Charge in Percentage'); ?></strong>
                                    <div class="input-group mb-3">
                                        <input type="text" name="percentage_charge" class="form-control">
                                            <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-2">
                        <strong><?php echo app('translator')->get('Payment Details'); ?></strong>
                        <textarea name="gateway_key_four" rows="3" cols="80" class="form-control"></textarea>
                    </div>

                    <div class="form-group mb-2">
                        <strong><?php echo app('translator')->get('Status'); ?></strong>
                        <select class="form-select" name="status">
                            <option value="1"><?php echo app('translator')->get('Active'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/deposit/gateway.blade.php ENDPATH**/ ?>