<?php $__env->startSection('title',__('Plan Create')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('plan-area.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row mb-2">
                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Plan Name'); ?></label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group col-md-4">
                        <label class="form-label"><?php echo app('translator')->get('Plan Type'); ?></label>
                        <select name="return_time_status" id="planType" class="form-select">
                            <option disabled selected value=""><?php echo app('translator')->get('Choose One'); ?></option>
                            <option value="1"><?php echo app('translator')->get('ROI Invest'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Fixed Invest'); ?></option>
                        </select>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Capital Back'); ?></label>
                        <select name="capital_back_status" class="form-select">
                            <option disabled selected value=""><?php echo app('translator')->get('Choose One'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Capital Not Back'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Capital Back'); ?></option>
                        </select>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="form-group col-md-6">
                        <label class="form-label"><?php echo app('translator')->get('Return Percentage'); ?></label>
                        <input type="text" class="form-control" name="percent" required>
                    </div>

                    <div class="form-group col-md-6">
                        <label class="form-label"><?php echo app('translator')->get('Return Period'); ?></label>
                        <select name="period" class="form-select" required>
                            <option value="" selected disabled><?php echo app('translator')->get('Select a Period'); ?></option>
                            <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($data->time); ?>"><?php echo app('translator')->get('Every'); ?> <?php echo e($data->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="roiInvest mb-2">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Minimum Amount'); ?></label>
                            <input type="text" class="form-control" name="min_amount">
                        </div>

                        <div class="form-group col-md-6 mb-2">
                            <label class="form-label"><?php echo app('translator')->get('Maximum Amount'); ?></label>
                            <input type="text" class="form-control" name="max_amount">
                        </div>

                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Return Action (How many time)'); ?></label>
                            <input type="number" class="form-control" name="action">
                        </div>
                    </div>
                </div>
                <div class="fixedInvest mb-2">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="form-label"><?php echo app('translator')->get('Fixed Amount (Return Action #Liftime)'); ?></label>
                            <input type="text" class="form-control" name="fixed_amount">
                        </div>
                    </div>
                </div>

                <div class="text-center">
                    <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
        $(document).ready(function () {
            $('#planType').on('change',function () {
                if (this.value == 1){
                    $('.fixedInvest').css('display','none');
                    $('.roiInvest').css('display','block');
                }
                if (this.value == 0){
                    $('.roiInvest').css('display','none');
                    $('.fixedInvest').css('display','block');
                }
            })
        })
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/plan/create.blade.php ENDPATH**/ ?>