
<?php $__env->startSection('title',''.$user->name); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="col-md-12">
                <div class="card mb-5">
                    <div class="card-header">
                        <div class="card-title"><i class="fa fa-user"></i> <?php echo app('translator')->get('PROFILE'); ?> </div>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-md-12 mb-3">
                                <h5 class="bold"><?php echo e($user->name); ?> </h5>
                                <br>
                                <h3><?php echo e($user->email); ?> </h3>
                            </div>
                            <div class="col-md-12">
                                <h3 class="bold"><?php echo app('translator')->get('BALANCE'); ?> : <?php echo e($user->balance); ?> <?php echo e($general->currency); ?></h3>
                                <p class="bold"><?php echo app('translator')->get('Joined'); ?> <?php echo e($user->created_at->format('d/m/y  h:i A')); ?></p>
                            </div>
                        </div>
    
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="row">
                <div class="col-md-12">
                    <div class="card mb-5">
                        <div class="card-header">
                            <div class="card-title">
                                <i class="fa fa-cogs e6fffa"></i> <?php echo app('translator')->get('Operations'); ?> </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <a href="<?php echo e(route('add.subs.index', $user->id)); ?>" class="btn btn-primary w-100"> <i class="fas fa-money-bill-alt"></i> <?php echo app('translator')->get('Add / Deduct balance'); ?>  </a>
                                </div>
                                <div class="col-md-6">
                                    <a href="<?php echo e(route('user.mail.send', $user->id)); ?>" class="btn btn-info w-100"> <i class="fa fa-envelope"></i> <?php echo app('translator')->get('Send Email'); ?>  </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="card mb-5">
                        <div class="card-header">
                            <div class="card-title">
                                <i class="fa fa-cogs e6fffa"></i> <?php echo app('translator')->get('Wallet'); ?> 
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table s7__table">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Address'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->wallet_name); ?></td>
                                    <td><?php echo e($item->address); ?></td>
                                    <td>
                                        <?php if($item->status == 0): ?>
                                        <a href="#active<?php echo e($item->id); ?>" data-bs-toggle="modal" class="btn btn-success btn-sm"><?php echo app('translator')->get('Active'); ?></a>
                                        <?php else: ?>
                                        <a href="#reject<?php echo e($item->id); ?>" data-bs-toggle="modal" class="btn btn-danger btn-sm"><?php echo app('translator')->get('Deactive'); ?></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <div id="active<?php echo e($item->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title"><?php echo app('translator')->get('Confirm Active'); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form role="form" action="<?php echo e(route('adm-active-wallet.update', $item->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <h2 class="text-danger"><?php echo app('translator')->get('Are you sure?'); ?></h2>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                                    <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Confirm'); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div id="reject<?php echo e($item->id); ?>" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title"><?php echo app('translator')->get('Confirm Active'); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form role="form" action="<?php echo e(route('adm-reject-wallet.update', $item->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <h2 class="text-danger"><?php echo app('translator')->get('Are you sure?'); ?></h2>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                                    <button type="submit" class="btn btn-danger"><?php echo app('translator')->get('Confirm'); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="card mb-5">
                        <div class="card-header">
                            <div class="card-title"><i class="fa fa-cog"></i> <?php echo app('translator')->get('Update Profile'); ?> </div>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('user.detail.update', $user->id)); ?>" method="post">
                                <?php echo e(csrf_field()); ?>

                                <?php echo e(method_field('put')); ?>


                                <div class="row mb-3">
                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Name'); ?></strong>
                                        <input class="form-control" name="name" value="<?php echo e($user->name); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Mobile'); ?></strong>
                                        <input class="form-control" name="mobile" value="<?php echo e($user->mobile); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Gender'); ?></strong>
                                        <select name="gender" class="form-select">
                                            <option <?php echo e($user->gender == 1? 'selected':''); ?> value="1"><?php echo app('translator')->get('Male'); ?></option>
                                            <option <?php echo e($user->gender == 0? 'selected':''); ?> value="0"><?php echo app('translator')->get('Female'); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Address'); ?></strong>
                                        <input class="form-control" name="address" value="<?php echo e($user->address); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Zip-Code'); ?></strong>
                                        <input class="form-control" name="zip_code" value="<?php echo e($user->zip_code); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('City'); ?></strong>
                                        <input class="form-control" name="city" value="<?php echo e($user->city); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Country'); ?></strong>
                                        <input class="form-control" name="country" value="<?php echo e($user->country); ?>" type="text">
                                    </div>

                                    <div class="form-group col-md-4 mb-2">
                                        <strong><?php echo app('translator')->get('Status'); ?></strong>
                                        <select name="status" class="form-select">
                                            <option <?php echo e($user->status == 1? 'selected':''); ?> value="1"><?php echo app('translator')->get('Active'); ?></option>
                                            <option <?php echo e($user->status == 0? 'selected':''); ?> value="0"><?php echo app('translator')->get('Banded'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-block "><?php echo app('translator')->get('Update'); ?></button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/user/view.blade.php ENDPATH**/ ?>