<?php $__env->startSection('title',__('Edit Your Profile')); ?>
<?php $__env->startSection('content'); ?>
<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title"><?php echo e(__('Update Profile')); ?> </h2>
                    </div>
                    <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Name')); ?></label>
                                    <input name="name" value="<?php echo e($user->name); ?>" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Mobile')); ?></label>
                                    <input name="mobile" value="<?php echo e($user->mobile); ?>" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Gender')); ?></label>
                                    <select class="form-select" name="gender">
                                        <option <?php echo e($user->gender == 0? 'selected':''); ?> value="1"><?php echo e(__('Male')); ?></option>
                                        <option <?php echo e($user->gender == 1? 'selected':''); ?> value="0"><?php echo e(__('Female')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Address')); ?></label>
                                    <input name="address" value="<?php echo e($user->address); ?>" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Zip-Code')); ?></label>
                                    <input name="zip_code" value="<?php echo e($user->zip_code); ?>" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('City')); ?></label>
                                    <input name="city" value="<?php echo e($user->city); ?>" type="text">
                                </div>
                            </div>
                            <div class="col-md-12 autocomplete">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Country')); ?></label>
                                    <input id="myInput" name="country" value="<?php echo e($user->country); ?>" type="text" autocomplete="off">
                                </div>
                            </div>
        
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5"><?php echo e(__('Submit')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title"><?php echo e(__('Change Password')); ?> </h2>
                    </div>
                    <form method="POST" action="<?php echo e(route('password.update')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Current Password')); ?> :</label>
                                    <input type="password" name="current_password" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('New Password')); ?> :</label>
                                    <input type="password" name="password" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label><?php echo e(__('Confirm Password')); ?> :</label>
                                    <input type="password" name="password_confirmation" required>
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5"><?php echo e(__('Submit')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('public/frontend/deepblue/js/countryWiseCity.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/profile.blade.php ENDPATH**/ ?>