<?php $__env->startSection('title',__('Referral')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4><?php echo app('translator')->get('Referral Bonus Settings'); ?> 
                <button id="addLevel" class="btn btn-success float-end btn-sm"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New Level'); ?></button>
            </h4>
        </div>

        <div class="card-body">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <p class="text-danger font-weight-bold"><?php echo app('translator')->get('NOTE : Insert "Blank or remove percentage value" for delete Level Bonus.'); ?></p>
                    <form action="<?php echo e(route('admin.referral.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <?php $__currentLoopData = $ref; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-group col-md-12">
                                    <label ><?php echo e($data->id); ?> <?php echo app('translator')->get('Level Bonus'); ?></label>
                                    <div class="input-group mb-3 ">
                                        <input type="text" class="form-control" name="percentage[]" placeholder="Bonus Percentage" value="<?php echo e($data->percentage); ?>" aria-describedby="basic-addon2">
                                        <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="form-row" id="newLevel">
        
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2"><?php echo app('translator')->get('Update'); ?></button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";
            <?php if(($lastRef instanceof \App\Referral)): ?>
             var count = parseInt('<?php echo e($lastRef->id); ?>');
            <?php else: ?>
            var count = 0;
            <?php endif; ?>
            $("#addLevel").on('click',function() {
                count += 1;
                $("#newLevel").append(
                    `<div class="form-group col-md-12">
                        <label >`+count+` Level Bonus</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="percentage[]" placeholder="Bonus Percentage"  aria-describedby="basic-addon2">
                            <span class="input-group-text" id="basic-addon2">%</span>
                        </div>
                    </div>`
                );
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/admin/referral/index.blade.php ENDPATH**/ ?>