<?php $__env->startSection('title', __('Payment Methods')); ?>
<?php $__env->startSection('content'); ?>
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6 align-self-center">
                <div class="single-payment-wrap">
                    <div class="thumb">
                        <img src="<?php echo e(asset('public/images/withdraw_methods')); ?>/<?php echo e($gate->image); ?>" alt="img">
                    </div>
                    <div class="details">
                        <h4><?php echo e(__($gate->name)); ?></h4>
                        <a class="read-more-arrow" href="#depositModal<?php echo e($gate->id); ?>" data-bs-toggle="modal"><i class="fa fa-angle-right"></i></a>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="depositModal<?php echo e($gate->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title text-white" id="exampleModalLabel"><?php echo e(__('Withdraw via')); ?> <?php echo e(__($gate->name)); ?></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="<?php echo e(route('withdraw.preview.user')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <p class="text-danger"><?php echo e(__('Charge for withdraw Amount')); ?>: <?php echo e($gate->chargefx); ?> <?php echo e($general->currency); ?></p>
                            <p class="text-white"><?php echo e(__('Percentage Charge')); ?>: <?php echo e($gate->chargepc); ?> %</p>
                            <p class="text-danger"><?php echo e(__('Processing Days (At last)')); ?> : <?php echo e($gate->processing_day); ?> <?php echo e(__('Days')); ?></p>
                            <p class="text-success"> <?php echo e(__('Minimum')); ?> <?php echo e($gate->min_amo); ?><?php echo e($general->currency); ?> & <?php echo e(__('Maximum')); ?> <?php echo e($gate->max_amo); ?> <?php echo e($general->currency); ?></p>
                            <hr/>
                            <input type="hidden" name="gateway" value="<?php echo e($gate->id); ?>">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" name="amount" class="form-control" id="amount" placeholder="<?php echo e(__('AMOUNT YOU WANT TO WITHDRAW')); ?>" required>
                                    <span class="input-group-text"><?php echo e($general->currency); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success"><?php echo e(__('Preview')); ?></button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        </div>
                    </form>
                  </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metrqiuu/public_html/resources/views/theme/deepblack/user/withdraw/methods.blade.php ENDPATH**/ ?>