@extends('admin.layouts.master')
@section('title',__('Settings'))
@section('content')
<div class="card">
    <div class="card-body">
        <form class="form-cont" action="{{route('general.store')}}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-4">
                    <label class="form-label">@lang('Website Name')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="web_name" value="{{$general->web_name}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Website Currency (Ex: USD, EURO)')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="currency" value="{{$general->currency}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Color Code (Note: Do not use "#")')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="color_code" value="{{$general->color_code}}">
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold">@lang('Paginate Per Page')</label>
                    <input type="text" name="paginate" value="{{ old('paginate') ?? $general->paginate ?? '2' }}"
                            required="required" class="form-control ">
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Fixed Charge (Balance Transfer)')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="bal_trans_fixed_charge" value="{{$general->bal_trans_fixed_charge}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Percentage (%) Charge (Balance Transfer)')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="bal_trans_percentage_charge" value="{{$general->bal_trans_percentage_charge}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Contact Email')</label>
                    <div class="input-group">
                        <input type="email" class="form-control" name="contact_email" value="{{$general->contact_email}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Contact Phone')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="contact_phone" value="{{$general->contact_phone}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">@lang('Contact Address')</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="contact_address" value="{{$general->contact_address}}">
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold">@lang('Minimum Transfer')</label>
                    <input type="text" name="min_transfer" value="{{ old('min_transfer') ?? $general->min_transfer ?? '1' }}"
                            required="required" class="form-control ">
                </div>

                <div class="form-group col-md-4">
                    <label class="font-weight-bold">@lang('Maximum Transfer')</label>
                    <input type="text" name="max_transfer" value="{{ old('max_transfer') ?? $general->max_transfer ?? '1000' }}"
                            required="required" class="form-control ">
                </div>
                <div class="form-group col-md-4">
                    <label class="font-weight-bold">@lang('Bonus Amount')</label>
                    <div class="input-group mb-3">
                        <input type="text" name="bonus_amount" value="{{ old('bonus_amount') ?? $general->bonus_amount ?? '0' }}"
                                required="required" class="form-control">
                            <span class="input-group-text" >{{trans($general->currency)}}</span>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">@lang('CopyRight Text')</label>
                    <div class="input-group">
                        <textarea class="form-control" name="copyright_text" id="" cols="30" rows="5">{{$general->copyright_text}}</textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <label class="form-label">@lang('Comment Script')</label>
                    <div class="input-group">
                        <textarea class="form-control" name="comment_script" id="" cols="30" rows="5">{{$general->comment_script}}</textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <label class="form-label">@lang('Live Chat Script')</label>
                    <div class="input-group">
                        <textarea class="form-control" name="livechat_script" id="" cols="30" rows="5">{{$general->livechat_script}}</textarea>
                    </div>
                </div>
                <div class="col-md-6 mb-2">
                    <div class="form-group">
                        <label class="form-label">@lang('Footer Text')</label>
                        <textarea class="form-control" name="footer_text"cols="30" rows="5">{{$general->footer_text}}</textarea>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="form-label">@lang('Days Wise Cron Payment')</label>
                    <div class="input-group">
                        <select class="form-select days_cron" aria-label="multiple select example" multiple="multiple" name="date_wise_action[]" required>
                            <option value="Sat" {{ is_array(json_decode($general->date_wise_action)) && in_array("Sat", json_decode($general->date_wise_action))? 'selected' : '' }}>Saturday</option>
                            <option value="Sun" {{ is_array(json_decode($general->date_wise_action)) && in_array("Sun", json_decode($general->date_wise_action))? 'selected' : '' }}>Sunday</option>
                            <option value="Mon" {{ is_array(json_decode($general->date_wise_action)) && in_array("Mon", json_decode($general->date_wise_action))? 'selected' : '' }}>Monday</option>
                            <option value="Tue" {{ is_array(json_decode($general->date_wise_action)) && in_array("Tue", json_decode($general->date_wise_action))? 'selected' : '' }}>Tuesday</option>
                            <option value="Wed" {{ is_array(json_decode($general->date_wise_action)) && in_array("Wed", json_decode($general->date_wise_action))? 'selected' : '' }}>Wednesday</option>
                            <option value="Thu" {{ is_array(json_decode($general->date_wise_action)) && in_array("Thu", json_decode($general->date_wise_action))? 'selected' : '' }}>Thursday</option>
                            <option value="Fri" {{ is_array(json_decode($general->date_wise_action)) && in_array("Fri", json_decode($general->date_wise_action))? 'selected' : '' }}>Friday</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="form-label">@lang('EMAIL VERIFICATION')</label>
                    <div class="onOff-radio-field">
                        <div class="onOff-radio-option">
                            <input type="radio" name="emailver" id="emailver" value="1" <?php if ($general->emailver == 1):echo 'checked'; endif ?>>
                            <label class="bgc-success" for="emailver">ON</label>
                        </div>

                        <div class="onOff-radio-option">
                            <input type="radio" name="emailver" id="emailver1" value="0" <?php if ($general->emailver == 0):echo 'checked'; endif ?>>
                            <label class="bgc-danger" for="emailver1">OFF</label>
                        </div>
                    </div>
                </div>
                
                <div class="form-group col-md-4 ">
                    <label class="font-weight-bold">@lang('Joining bonus')</label>
                    <div class="onOff-radio-field">
                        <div class="onOff-radio-option">
                            <input type="radio" name="joining_bonus" id="joining_bonus" value="1" <?php if ($general->joining_bonus == 1):echo 'checked'; endif ?>>
                            <label class="bgc-success" for="joining_bonus">ON</label>
                        </div>

                        <div class="onOff-radio-option">
                            <input type="radio" name="joining_bonus" id="joining_bonus1" value="0" <?php if ($general->joining_bonus == 0):echo 'checked'; endif ?>>
                            <label class="bgc-danger" for="joining_bonus1">OFF</label>
                        </div>
                    </div>
                </div>
            </div>
            <br>
            <div class="text-center">
                <button type="submit" class="btn s7__btn-primary s7__bg-base mt-2">{{__('Update')}}</button>
            </div>
        </form>
    </div>
</div>
@endsection

