@extends($theme.'frontend.layouts.master')
@section('title',__('Edit Your Profile'))
@section('content')
<div class="contact-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 profile-card-area contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Update Profile')}} </h2>
                    </div>
                    <form method="POST" action="{{ route('profile.update') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Name')}}</label>
                                    <input name="name" value="{{$user->name}}" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Mobile')}}</label>
                                    <input name="mobile" value="{{$user->mobile}}" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Gender')}}</label>
                                    <select class="form-select" name="gender">
                                        <option {{$user->gender == 0? 'selected':''}} value="1">{{__('Male')}}</option>
                                        <option {{$user->gender == 1? 'selected':''}} value="0">{{__('Female')}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Address')}}</label>
                                    <input name="address" value="{{$user->address}}" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Zip-Code')}}</label>
                                    <input name="zip_code" value="{{$user->zip_code}}" type="text">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('City')}}</label>
                                    <input name="city" value="{{$user->city}}" type="text">
                                </div>
                            </div>
                            <div class="col-md-12 autocomplete">
                                <div class="single-input-inner">
                                    <label>{{__('Country')}}</label>
                                    <input id="myInput" name="country" value="{{$user->country}}" type="text" autocomplete="off">
                                </div>
                            </div>
        
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Submit')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6 col-md-8">
                <div class="contact-page-inner bg-black-2 password-card-area contact-page-inner-cust">
                    <div class="section-title mb-4 pb-2 text-center">
                        <h2 class="title">{{__('Change Password')}} </h2>
                    </div>
                    <form method="POST" action="{{ route('password.update') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Current Password')}} :</label>
                                    <input type="password" name="current_password" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('New Password')}} :</label>
                                    <input type="password" name="password" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="single-input-inner">
                                    <label>{{__('Confirm Password')}} :</label>
                                    <input type="password" name="password_confirmation" required>
                                </div>
                            </div>
                            <div class="col-12 text-center mt-3 mb-3">
                                <button type="submit" class="btn btn-base border-radius-5 pe-5 ps-5">{{__('Submit')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{asset('public/frontend/deepblue/js/countryWiseCity.js')}}"></script>
@endsection
