@extends($theme.'frontend.layouts.master')
@section('title',__('Withdraw History'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table style-2">
                <thead>
                    <tr>
                        <th>{{__('Gateway Name')}}</th>
                        <th>{{__('Amount')}}</th>
                        <th>{{__('Charge')}}</th>
                        <th>{{__('Method Cur Amount')}}</th>
                        <th>{{__('Status')}}</th>
                        <th>{{__('Transaction ID')}}</th>
                        <th>{{__('Time')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($deposits as $deposit)
                    <tr>
                        <td data-label="Email">{{__($deposit->method_name)}}</td>
                        <td data-label="Username">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                        <td data-label="Mobile">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                        <td data-label="Balance">{{round($deposit->amount*$deposit->method_rate, 8)}} {{$deposit->method_cur}}</td>
                        @if($deposit->status == 0)
                            <td data-label="Balance"><span class="badge bg-warning text-dark">{{__('pending')}}</span></td>
                        @elseif($deposit->status == 1)
                            <td data-label="Balance"><span class="badge bg-success">{{__('complete')}}</span></td>
                        @else
                            <td data-label="Balance"><span class="badge bg-danger">{{__('rejected')}}</span></td>
                        @endif
                        <td  data-label="Details">{{$deposit->withdraw_id}}</td>
                        <td  data-label="Time">{{$deposit->updated_at->format('d/m/y  h:i A')}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    {{$deposits->links()}}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
