doc/alt-php71-snuffleupagus/CONTRIBUTING.md                                                         0000644                 00000013046 15117526144 0014156 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       Killing several classes of vulnerabilities
  * [Unserialize-based](https://www.owasp.org/images/9/9e/Utilizing-Code-Reuse-Or-Return-Oriented-Programming-In-PHP-Application-Exploits.pdf) code execution
  * [`mail`-based]( https://blog.ripstech.com/2016/roundcube-command-execution-via-email/ ) code execution
  * Cookie-stealing [XSS]( https://en.wikipedia.org/wiki/Cross-site_scripting )
  * File-upload based code execution
  * Weak PRNG
  * [XXE]( https://en.wikipedia.org/wiki/XML_external_entity_attack )
  * Filter based remote code execution and assorted shenanigans
* Several hardening features
  * Automatic `secure` and `samesite` flag for cookies
  * Bundled set of rules to detect post-compromissions behaviours
  * Global [strict mode]( https://secure.php.net/manual/en/migration70.new-features.php#migration70.new-features.scalar-type-declarations) and type-juggling prevention
  * Whitelisting of [stream wrappers](https://secure.php.net/manual/en/intro.stream.php)
  * Preventing writeable files execution
  * Whitelist/blacklist for `eval`
  * Enforcing TLS certificate validation when using [curl](https://secure.php.net/manual/en/book.curl.php)
  * Request dumping capability
* A relatively sane code base:
  * A [comprehensive](https://coveralls.io/github/jvoisin/snuffleupagus?branch=master) test suite close to 100% coverage
  * Every commit is tested on [several distributions](https://gitlab.com/jvoisin/snuffleupagus/pipelines)
  * An `clang-format`-enforced code style
  * A [comprehensive documentation](https://snuffleupagus.rtfd.io)
  * Usage of [coverity](https://scan.coverity.com/projects/jvoisin-snuffleupagus), codeql, [scan-build](https://clang-analyzer.llvm.org/scan-build.html), …

## Download

We've got a [download
page](https://snuffleupagus.readthedocs.io/download.html), where you can find
packages for your distribution, but you can of course just `git clone` this
repo, or check the releases on [github](https://github.com/jvoisin/snuffleupagus/releases).

## Examples

We're providing [various example rules](https://github.com/jvoisin/snuffleupagus/tree/master/config),
that are looking like this:

```python
# Harden the `chmod` function
sp.disable_function.function("chmod").param("mode").value_r("^[0-9]{2}[67]$").drop();

# Mitigate command injection in `system`
sp.disable_function.function("system").param("command").value_r("[$|;&`\\n]").drop();
```

Upon violation of a rule, you should see lines like this in your logs:

```python
[snuffleupagus][0.0.0.0][disabled_function][drop] The execution has been aborted in /var/www/index.php:2, because the return value (0) of the function 'strpos' matched a rule.
```

## Documentation

We've got a [comprehensive website](https://snuffleupagus.readthedocs.io/) with
all the documentation that you could possibly wish for. You can of course
[build it yourself](https://github.com/jvoisin/snuffleupagus/tree/master/doc).

## Thanks

Many thanks to:

- The [Suhosin project](https://suhosin.org) for being a __huge__ source of inspiration
- [NBS System](https://www.nbs-system.com) for initially sponsoring the development
- [Suhosin-ng](https://github.com/sektioneins/suhosin-ng) for their
  [experimentations](https://github.com/sektioneins/suhosin-ng/wiki/News)
  and [contributions](https://github.com/jvoisin/snuffleupagus/commits?author=bef),
  as well as [NLNet](https://nlnet.nl/project/Suhosin-NG/) for sponsoring it
- All [our contributors](https://github.com/jvoisin/snuffleupagus/graphs/contributors)

                                                                         doc/alt-php71-snuffleupagus/CONTRIBUTING.md                                                         0000644                 00000013046 15117526144 0014156 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ## Contributing

First off, thank you for considering contributing to snuffleupagus.

### 1. Where do I go from here?

If you've noticed a bug or have a question,
look at the [faq](https://snuffleupagus.readthedocs.io/faq.html) and
[search the issue tracker](https://github.com/jvoisin/snuffleupagus/issues)
to see if someone else has already created a ticket. If not, go ahead and
[make one](https://github.com/jvoisin/snuffleupagus/issues/new)!

### 2. Fork & create a branch

If this is something you think you can fix,
then [fork snuffleupagus](https://help.github.com/articles/fork-a-repo) and
create a branch with a descriptive name.

A good branch name would be (where issue #325 is the ticket you're working on):

```sh
git checkout -b 325-kill-sql-injections
```

### 3. Get the test suite running

Just type `make coverage` or `make debug`, the testsuite should be run
automatically.

Please add tests if you're fixing a bug or adding a new feature: we do have a
[high coverage](https://coveralls.io/github/jvoisin/snuffleupagus?branch=master)
(functio