doc/pear/Archive/docs/example.php                                                                   0000644                 00000002701 15117524205 0012717 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * @package Archive
 */

// Add "MyDirectory" to a new archive: myArchive.tar
// [ tar -cf myArchive.tar MyDirectory ]

$ar = new Tar( "myArchive.tar" );
$ar->append( "MyDirectory" );

// Show the files in the archive.
// [ tar -tf myArchive.tar ]
$fileListing = $ar->getList();
foreach( $fileListing as $file )
{
    print( "Archived file: $file\n" );
}

// Append the file /etc/passwd
// [ tar -rf myArchive.tar /etc/passwd ]
$ar->append( "/etc/passwd" );

// Delete the directory and it's contents
// [ tar -f myArchive.tar --delete MyDirectory ]
$ar->delete( "MyDirectory" );

// Append another directory .. 
$ar->append( "AnotherDirectory" );

// .. and show detailed file permissions plus the file or directory path.
$fileListing = $ar->getList();
foreach( $fileListing as $file )
{
    $entry = $ar->getArchivedEntry( $file );

    print( $entry->getPermissionsString() );

    if ( $entry->isDirectory() )
    {
        print( " [ ".$entry->ge