pear/Symfony/Component/ClassLoader/DebugUniversalClassLoader.php                                    0000644                 00000004051 15117524552 0021051 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\ClassLoader;

/**
 * Checks that the class is actually declared in the included file.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 */
class DebugUniversalClassLoader extends UniversalClassLoader
{
    /**
     * Replaces all regular UniversalClassLoader instances by a DebugUniversalClassLoader ones.
     */
    public static function enable()
    {
        if (!is_array($functions = spl_autoload_functions())) {
            return;
        }

        foreach ($functions as $function) {
            spl_autoload_unregister($function);
        }

        foreach ($functions as $function) {
            if (is_array($function) && $function[0] instanceof UniversalClassLoader) {
                $loader = new static();
                $loader->registerNamespaceFallbacks($function[0]->getNamespaceFallbacks());
                $loader->registerPrefixFallbacks($function[0]->getPrefixFallbacks());
                $loader->registerNamespaces($function[0]->getNamespaces());
                $loader->registerPrefixes($function[0]->getPrefixes());
                $loader->useIncludePath($function[0]->getUseIncludePath());

                $function[0] = $loader;
            }

            spl_autoload_register($function);
        }
    }

    /**
     * {@inheritDoc}
     */
    public function loadC