pear/Symfony/Component/Security/Acl/Domain/RoleSecurityIdentity.php                                 0000644                 00000003075 15117524625 0021507 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Security\Acl\Domain;

use Symfony\Component\Security\Acl\Model\SecurityIdentityInterface;
use Symfony\Component\Security\Core\Role\Role;

/**
 * A SecurityIdentity implementation for roles
 *
 * @author Johannes M. Schmitt <schmittjoh@gmail.com>
 */
final class RoleSecurityIdentity implements SecurityIdentityInterface
{
    private $role;

    /**
     * Constructor
     *
     * @param mixed $role a Role instance, or its string representation
     */
    public function __construct($role)
    {
        if ($role instanceof Role) {
            $role = $role->getRole();
        }

        $this->role = $role;
    }

    /**
     * Returns the role name
     *
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * {@inheritDoc}
     */
    public fun