pear/Symfony/Component/Security/Acl/Model/AclCacheInterface.php                                     0000644                 00000002773 15117524625 0020445 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Security\Acl\Model;

/**
 * AclCache Interface
 *
 * @author Johannes M. Schmitt <schmittjoh@gmail.com>
 */
interface AclCacheInterface
{
    /**
     * Removes an ACL from the cache
     *
     * @param string $primaryKey a serialized primary key
     */
    public function evictFromCacheById($primaryKey);

    /**
     * Removes an ACL from the cache
     *
     * The ACL which is returned, must reference the passed object identity.
     *
     * @param ObjectIdentityInterface $oid
     */
    public function evictFromCacheByIdentity(ObjectIdentityInterface $oid);

    /**
     * Retrieves an ACL for the given object identity primary key from the cache
     *
     * @param integer $primaryKey
     * @return AclInterface
     */
    public fu