pear/ezc/Archive/utils/stat_mode.php                                                                0000644                 00000003067 15117524255 0013502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * File containing the ezcArchiveStatMode class.
 *
 * @package Archive
 * @version 1.4.1
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 * @access private
 */

/**
 * The ezcArchiveStatMode class stores the stat-mode constant values.
 *
 * Compare the bits from the "mode" array element from {@link http://www.php.net/stat}.
 * For example to get the file permissions in an octal number:
 * <code>
 * $stat = stat( "/tmp/myfile.txt" );
 * $perm = decoct( $stat["mode"] & ezcArchiveStatMode::S_PERM_MASK );
 * </code>
 *
 * To see if the file is a directory, the following code can be used:
 * <code>
 * $stat = stat( "/tmp/myfile.txt" );
 * $isDirectory = ( ( $stat["mode"] & S_FMT ) == ezcArchiveStatMode::S_IFDIR );
 * </code>
 *
 * @package Archive
 * @version 1.4.1
 * @access private
 */
class ezcArchiveStatMode
{
    /**
     * Type of the file.
     */
    const S_IFMT = 0170000;

    /**
     * Named pipe (fifo).
     */
    const S_IFIFO = 0010000;

    /**
     * charac