<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$translogic_content = '';
$translogic_blog_archive_mask = '%%CONTENT%%';
$translogic_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $translogic_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($translogic_content = apply_filters('the_content', get_the_content())) != '') {
		if (($translogic_pos = strpos($translogic_content, $translogic_blog_archive_mask)) !== false) {
			$translogic_content = preg_replace('/(\<p\>\s*)?'.$translogic_blog_archive_mask.'(\s*\<\/p\>)/i', $translogic_blog_archive_subst, $translogic_content);
		} else
			$translogic_content .= $translogic_blog_archive_subst;
		$translogic_content = explode($translogic_blog_archive_mask, $translogic_content);
	}
}

// Prepare args for a new query
$translogic_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$translogic_args = translogic_query_add_posts_and_cats($translogic_args, '', translogic_get_theme_option('post_type'), translogic_get_theme_option('parent_cat'));
$translogic_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($translogic_page_number > 1) {
	$translogic_args['paged'] = $translogic_page_number;
	$translogic_args['ignore_sticky_posts'] = true;
}
$translogic_ppp = translogic_get_theme_option('posts_per_page');
if ((int) $translogic_ppp != 0)
	$translogic_args['posts_per_page'] = (int) $translogic_ppp;
// Make a new query
query_posts( $translogic_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($translogic_content) && count($translogic_content) == 2) {
	set_query_var('blog_archive_start', $translogic_content[0]);
	set_query_var('blog_archive_end', $translogic_content[1]);
}

get_template_part('index');
?>