<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_full_content = translogic_get_theme_option('blog_content') != 'excerpt' || in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'));
$translogic_animation = translogic_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	><?php

	// Featured image
	translogic_show_post_featured(array( 'thumb_size' => translogic_get_thumb_size( strpos(translogic_get_theme_option('body_style'), 'full')!==false ? 'full' : 'huge' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('translogic_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );

			do_action('translogic_action_before_post_meta'); 

			// Post meta
			translogic_show_post_meta(array(
				'categories' => false,
				'date' => true,
				'author' => true,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => 'comments'	//comments,likes,views - comma separated in any combination
				)
			);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if ($translogic_full_content) {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'translogic' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'translogic' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$translogic_show_learn_more = !in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $translogic_show_learn_more ) {
				?><p><a class="more-link sc_button_border" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'translogic'); ?><span class="icon-right"></span></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>