<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_blog_style = explode('_', translogic_get_theme_option('blog_style'));
$translogic_columns = empty($translogic_blog_style[1]) ? 2 : max(2, $translogic_blog_style[1]);
$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_animation = translogic_get_theme_option('blog_animation');
$translogic_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($translogic_columns).' post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($translogic_image[1]) && !empty($translogic_image[2])) echo intval($translogic_image[1]) .'x' . intval($translogic_image[2]); ?>"
	data-src="<?php if (!empty($translogic_image[0])) echo esc_url($translogic_image[0]); ?>"
	>

	<?php
	$translogic_image_hover = 'icon';
	if (in_array($translogic_image_hover, array('icons', 'zoom'))) $translogic_image_hover = 'dots';
	// Featured image
	translogic_show_post_featured(array(
		'hover' => $translogic_image_hover,
		'thumb_size' => translogic_get_thumb_size( strpos(translogic_get_theme_option('body_style'), 'full')!==false || $translogic_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. the_title_attribute( array( 'echo' => false ) ) . '</a></h2>'
							. '<div class="post_description">'
								. translogic_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'translogic') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>