<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_blog_style = explode('_', translogic_get_theme_option('blog_style'));
$translogic_columns = empty($translogic_blog_style[1]) ? 2 : max(2, $translogic_blog_style[1]);
$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_animation = translogic_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($translogic_columns).' post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	>

	<?php
	$translogic_image_hover = translogic_get_theme_option('image_hover');
	// Featured image
	translogic_show_post_featured(array(
		'thumb_size' => translogic_get_thumb_size(strpos(translogic_get_theme_option('body_style'), 'full')!==false || $translogic_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $translogic_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $translogic_image_hover == 'dots' ? '<div class="post_info">'.the_title_attribute( array( 'echo' => false ) ).'</div>' : ''
	));
	?>
</article>