<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_animation = translogic_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($translogic_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	translogic_show_post_featured(array(
		'thumb_size' => translogic_get_thumb_size($translogic_columns==1 ? 'big' : ($translogic_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($translogic_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			translogic_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>