<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

						// Widgets area inside page content
						translogic_create_widgets_area('widgets_below_content');
						?>				
					</div><!-- </.content> -->

					<?php
					// Show main sidebar
					get_sidebar();

					// Widgets area below page content
					translogic_create_widgets_area('widgets_below_page');

					$translogic_body_style = translogic_get_theme_option('body_style');
					if ($translogic_body_style != 'fullscreen') {
						?></div><!-- </.content_wrap> --><?php
					}
					?>
			</div><!-- </.page_content_wrap> -->

			<?php
			$translogic_footer_scheme =  translogic_is_inherit(translogic_get_theme_option('footer_scheme')) ? translogic_get_theme_option('color_scheme') : translogic_get_theme_option('footer_scheme');
			?>
			
			<footer class="site_footer_wrap scheme_<?php echo esc_attr($translogic_footer_scheme); ?>">
				<?php
				// Footer sidebar
				$translogic_footer_name = translogic_get_theme_option('footer_widgets');
				$translogic_footer_present = !translogic_is_off($translogic_footer_name) && is_active_sidebar($translogic_footer_name);
				if ($translogic_footer_present) { 
					translogic_storage_set('current_sidebar', 'footer');
					$translogic_footer_wide = translogic_get_theme_option('footer_wide');
					ob_start();
					if ( is_active_sidebar( $translogic_footer_name ) ) {
						dynamic_sidebar( $translogic_footer_name );
			  		}
					$translogic_out = trim(ob_get_contents());
					ob_end_clean();
					if (trim(strip_tags($translogic_out)) != '') {
						$translogic_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $translogic_out);
						$translogic_need_columns = true;
						if ($translogic_need_columns) {
							$translogic_columns = max(0, (int) translogic_get_theme_option('footer_columns'));
							if ($translogic_columns == 0) $translogic_columns = min(4, max(1, substr_count($translogic_out, '<aside ')));
							if ($translogic_columns > 1)
								$translogic_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($translogic_columns).' widget ', $translogic_out);
							else
								$translogic_need_columns = false;
						}
						?>
						<div class="footer_wrap widget_area<?php echo !empty($translogic_footer_wide) ? ' footer_fullwidth' : ''; ?>">
							<div class="footer_wrap_inner widget_area_inner">
								<?php 
								if (!$translogic_footer_wide) { 
									?><div class="content_wrap"><?php
								}
								if ($translogic_need_columns) {
									?><div class="columns_wrap"><?php
								}
								do_action( 'translogic_action_before_sidebar' );
								translogic_show_layout($translogic_out);
								do_action( 'translogic_action_after_sidebar' );
								if ($translogic_need_columns) {
									?></div><!-- /.columns_wrap --><?php
								}
								if (!$translogic_footer_wide) {
									?></div><!-- /.content_wrap --><?php
								}
								?>
							</div><!-- /.footer_wrap_inner -->
						</div><!-- /.footer_wrap -->
						<?php
					}
				}
	
				// Logo
				if (translogic_is_on(translogic_get_theme_option('logo_in_footer'))) {
					$translogic_logo_image = '';
					if (translogic_get_retina_multiplier(2) > 1)
						$translogic_logo_image = translogic_get_theme_option( 'logo_footer_retina' );
					if (empty($translogic_logo_image)) 
						$translogic_logo_image = translogic_get_theme_option( 'logo_footer' );
					$translogic_logo_text   = get_bloginfo( 'name' );
					if (!empty($translogic_logo_image) || !empty($translogic_logo_text)) {
						?>
						<div class="logo_footer_wrap">
							<div class="logo_footer_wrap_inner">
								<?php
								if (!empty($translogic_logo_image)) {
									$translogic_attr = translogic_getimagesize($translogic_logo_image);
									echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($translogic_logo_image).'" class="logo_footer_image" alt="'. esc_attr(basename($translogic_logo_image)).'"'.(!empty($translogic_attr[3]) ? sprintf(' %s', $translogic_attr[3]) : '').'></a>' ;
								} else if (!empty($translogic_logo_text)) {
									echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($translogic_logo_text) . '</a></h1>';
								}
								?>
							</div>
						</div>
						<?php
					}
				}
				
				// Footer menu
				$translogic_menu_footer = translogic_get_nav_menu('menu_footer');
				if (!empty($translogic_menu_footer)) {
					?>
					<div class="menu_footer_wrap">
						<div class="menu_footer_wrap_inner">
							<?php translogic_show_layout($translogic_menu_footer); ?>
						</div>
					</div>
					<?php
				}
				
				// Copyright area
				$translogic_copyright_scheme = translogic_is_inherit(translogic_get_theme_option('copyright_scheme')) ? $translogic_footer_scheme : translogic_get_theme_option('copyright_scheme');
				$translogic_copyright_socials = ( translogic_is_on(translogic_get_theme_option('socials_in_footer')) && ($translogic_output = translogic_get_socials_links()) != '') ? true : false;
				?> 
				<div class="copyright_wrap <?php echo esc_attr($translogic_copyright_socials ? 'with_socials' : ''); ?> scheme_<?php echo esc_attr($translogic_copyright_scheme); ?>">
					<div class="copyright_wrap_inner">
						<div class="content_wrap">
							<div class="copyright_text"><?php
								$translogic_copyright = translogic_prepare_macros(translogic_get_theme_option('copyright'));
								if (!empty($translogic_copyright)) {
									if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $translogic_copyright, $translogic_matches)) {
										$translogic_copyright = str_replace($translogic_matches[1], date(str_replace(array('{', '}'), '', $translogic_matches[1])), $translogic_copyright);
									}
									translogic_show_layout(nl2br($translogic_copyright));
								}
							?></div>
							<?php
								// Socials
								if ( $translogic_copyright_socials ) {
									?>
									<div class="socials_footer_wrap socials_wrap">
										<div class="socials_footer_wrap_inner">
											<?php translogic_show_layout($translogic_output); ?>
										</div>
									</div>
									<?php
								}
							?>
						</div>
					</div>
				</div>

			</footer><!-- /.site_footer_wrap -->
			
		</div><!-- /.page_wrap -->

	</div><!-- /.body_wrap -->

	<?php if (translogic_is_on(translogic_get_theme_option('debug_mode')) && file_exists(translogic_get_file_dir('images/makeup.jpg'))) { ?>
		<img src="<?php echo esc_url(translogic_get_file_url('images/makeup.jpg')); ?>" id="makeup">
	<?php } ?>

	<?php wp_footer(); ?>

</body>
</html>