<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('translogic_storage_get')) {
	function translogic_storage_get($var_name, $default='') {
		global $TRANSLOGIC_STORAGE;
		return isset($TRANSLOGIC_STORAGE[$var_name]) ? $TRANSLOGIC_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('translogic_storage_set')) {
	function translogic_storage_set($var_name, $value) {
		global $TRANSLOGIC_STORAGE;
		$TRANSLOGIC_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('translogic_storage_empty')) {
	function translogic_storage_empty($var_name, $key='', $key2='') {
		global $TRANSLOGIC_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($TRANSLOGIC_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($TRANSLOGIC_STORAGE[$var_name][$key]);
		else
			return empty($TRANSLOGIC_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('translogic_storage_isset')) {
	function translogic_storage_isset($var_name, $key='', $key2='') {
		global $TRANSLOGIC_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($TRANSLOGIC_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($TRANSLOGIC_STORAGE[$var_name][$key]);
		else
			return isset($TRANSLOGIC_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('translogic_storage_inc')) {
	function translogic_storage_inc($var_name, $value=1) {
		global $TRANSLOGIC_STORAGE;
		if (empty($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = 0;
		$TRANSLOGIC_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('translogic_storage_concat')) {
	function translogic_storage_concat($var_name, $value) {
		global $TRANSLOGIC_STORAGE;
		if (empty($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = '';
		$TRANSLOGIC_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('translogic_storage_get_array')) {
	function translogic_storage_get_array($var_name, $key, $key2='', $default='') {
		global $TRANSLOGIC_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($TRANSLOGIC_STORAGE[$var_name][$key]) ? $TRANSLOGIC_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($TRANSLOGIC_STORAGE[$var_name][$key][$key2]) ? $TRANSLOGIC_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('translogic_storage_set_array')) {
	function translogic_storage_set_array($var_name, $key, $value) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if ($key==='')
			$TRANSLOGIC_STORAGE[$var_name][] = $value;
		else
			$TRANSLOGIC_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('translogic_storage_set_array2')) {
	function translogic_storage_set_array2($var_name, $key, $key2, $value) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if (!isset($TRANSLOGIC_STORAGE[$var_name][$key])) $TRANSLOGIC_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$TRANSLOGIC_STORAGE[$var_name][$key][] = $value;
		else
			$TRANSLOGIC_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('translogic_storage_merge_array')) {
	function translogic_storage_merge_array($var_name, $key, $value) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if ($key==='')
			$TRANSLOGIC_STORAGE[$var_name] = array_merge($TRANSLOGIC_STORAGE[$var_name], $value);
		else
			$TRANSLOGIC_STORAGE[$var_name][$key] = array_merge($TRANSLOGIC_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('translogic_storage_set_array_after')) {
	function translogic_storage_set_array_after($var_name, $after, $key, $value='') {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if (is_array($key))
			translogic_array_insert_after($TRANSLOGIC_STORAGE[$var_name], $after, $key);
		else
			translogic_array_insert_after($TRANSLOGIC_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('translogic_storage_set_array_before')) {
	function translogic_storage_set_array_before($var_name, $before, $key, $value='') {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if (is_array($key))
			translogic_array_insert_before($TRANSLOGIC_STORAGE[$var_name], $before, $key);
		else
			translogic_array_insert_before($TRANSLOGIC_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('translogic_storage_push_array')) {
	function translogic_storage_push_array($var_name, $key, $value) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($TRANSLOGIC_STORAGE[$var_name], $value);
		else {
			if (!isset($TRANSLOGIC_STORAGE[$var_name][$key])) $TRANSLOGIC_STORAGE[$var_name][$key] = array();
			array_push($TRANSLOGIC_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('translogic_storage_pop_array')) {
	function translogic_storage_pop_array($var_name, $key='', $defa='') {
		global $TRANSLOGIC_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($TRANSLOGIC_STORAGE[$var_name]) && is_array($TRANSLOGIC_STORAGE[$var_name]) && count($TRANSLOGIC_STORAGE[$var_name]) > 0) 
				$rez = array_pop($TRANSLOGIC_STORAGE[$var_name]);
		} else {
			if (isset($TRANSLOGIC_STORAGE[$var_name][$key]) && is_array($TRANSLOGIC_STORAGE[$var_name][$key]) && count($TRANSLOGIC_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($TRANSLOGIC_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('translogic_storage_inc_array')) {
	function translogic_storage_inc_array($var_name, $key, $value=1) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if (empty($TRANSLOGIC_STORAGE[$var_name][$key])) $TRANSLOGIC_STORAGE[$var_name][$key] = 0;
		$TRANSLOGIC_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('translogic_storage_concat_array')) {
	function translogic_storage_concat_array($var_name, $key, $value) {
		global $TRANSLOGIC_STORAGE;
		if (!isset($TRANSLOGIC_STORAGE[$var_name])) $TRANSLOGIC_STORAGE[$var_name] = array();
		if (empty($TRANSLOGIC_STORAGE[$var_name][$key])) $TRANSLOGIC_STORAGE[$var_name][$key] = '';
		$TRANSLOGIC_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('translogic_storage_call_obj_method')) {
	function translogic_storage_call_obj_method($var_name, $method, $param=null) {
		global $TRANSLOGIC_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($TRANSLOGIC_STORAGE[$var_name]) ? $TRANSLOGIC_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($TRANSLOGIC_STORAGE[$var_name]) ? $TRANSLOGIC_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('translogic_storage_get_obj_property')) {
	function translogic_storage_get_obj_property($var_name, $prop, $default='') {
		global $TRANSLOGIC_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($TRANSLOGIC_STORAGE[$var_name]->$prop) ? $TRANSLOGIC_STORAGE[$var_name]->$prop : $default;
	}
}
?>