<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('translogic_cf7_theme_setup9')) {
	add_action( 'after_setup_theme', 'translogic_cf7_theme_setup9', 9 );
	function translogic_cf7_theme_setup9() {
		if (translogic_exists_cf7()) {
			add_action( 'wp_enqueue_scripts', 'translogic_cf7_frontend_scripts', 1100 );
			add_filter( 'translogic_filter_merge_styles', 'translogic_cf7_merge_styles' );
			add_filter( 'translogic_filter_get_css', 'translogic_cf7_get_css', 10, 3 );
			add_filter('wpcf7_autop_or_not', 'translogic_cf7_wpcf7_autop');
		}
		if (is_admin()) {
			add_filter( 'translogic_filter_tgmpa_required_plugins', 'translogic_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'translogic_cf7_tgmpa_required_plugins' ) ) {
	
	function translogic_cf7_tgmpa_required_plugins($list=array()) {
		if (in_array('contact-form-7', translogic_storage_get('required_plugins'))) {
			$list[] = array(
					'name' 		=> esc_html__('Contact Form 7', 'translogic'),
					'slug' 		=> 'contact-form-7',
					'required' 	=> false
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( !function_exists( 'translogic_exists_cf7' ) ) {
	function translogic_exists_cf7() {
		return class_exists('WPCF7');
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'translogic_cf7_frontend_scripts' ) ) {
	
	function translogic_cf7_frontend_scripts() {
		if (translogic_is_on(translogic_get_theme_option('debug_mode')) && file_exists(translogic_get_file_dir('plugins/contact-form-7/contact-form-7.css')))
			wp_enqueue_style( 'translogic-contact-form-7',  translogic_get_file_url('plugins/contact-form-7/contact-form-7.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'translogic_cf7_merge_styles' ) ) {
	function translogic_cf7_merge_styles($list) {
		$list[] = 'plugins/contact-form-7/contact-form-7.css';
		return $list;
	}
}

// Remove <p> and <br/> from Contact Form 7
if ( ! function_exists( 'translogic_cf7_wpcf7_autop' ) ) {
	function translogic_cf7_wpcf7_autop() {
		return false;
	}
}


// Add cf7 specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'translogic_cf7_get_css' ) ) {
	
	function translogic_cf7_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

CSS;
		}
		
		return $css;
	}
}
?>