<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('translogic_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'translogic_revslider_theme_setup9', 9 );
	function translogic_revslider_theme_setup9() {
		if (is_admin()) {
			add_filter( 'translogic_filter_tgmpa_required_plugins',	'translogic_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'translogic_exists_revslider' ) ) {
	function translogic_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'translogic_revslider_tgmpa_required_plugins' ) ) {
	
	function translogic_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', translogic_storage_get('required_plugins'))) {
			$path = translogic_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'translogic'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'version'  => '6.6.13',
					'required' 	=> false
			);
		}
		return $list;
	}
}
?>