<?php
/* WPBakery Page Builder Extensions Bundle support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('translogic_vc_extensions_theme_setup9')) {
	add_action( 'after_setup_theme', 'translogic_vc_extensions_theme_setup9', 9 );
	function translogic_vc_extensions_theme_setup9() {
		if (translogic_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 										'translogic_vc_extensions_frontend_scripts', 1100 );
			add_filter( 'translogic_filter_merge_styles',						'translogic_vc_extensions_merge_styles' );
			add_filter( 'translogic_filter_get_css',							'translogic_vc_extensions_get_css', 10, 3 );
		}
	
		if (is_admin()) {
			add_filter( 'translogic_filter_tgmpa_required_plugins',		'translogic_vc_extensions_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'translogic_vc_extensions_tgmpa_required_plugins' ) ) {
	
	function translogic_vc_extensions_tgmpa_required_plugins($list=array()) {
		if (in_array('vc-extensions-bundle', translogic_storage_get('required_plugins'))) {
			$path = translogic_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.zip');
			$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder Extensions Bundle', 'translogic'),
					'slug' 		=> 'vc-extensions-bundle',
					'version'  => '3.6.5',
					'source'	=> !empty($path) ? $path : 'upload://vc-extensions-bundle.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if VC Extensions installed and activated
if ( !function_exists( 'translogic_exists_vc_extensions' ) ) {
	function translogic_exists_vc_extensions() {
		return class_exists('Vc_Manager') && class_exists('VC_Extensions_CQBundle');
	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'translogic_vc_extensions_frontend_scripts' ) ) {
	
	function translogic_vc_extensions_frontend_scripts() {
		if (translogic_is_on(translogic_get_theme_option('debug_mode')) && file_exists(translogic_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.css')))
			wp_enqueue_style( 'translogic-vc-extensions-bundle',  translogic_get_file_url('plugins/vc-extensions-bundle/vc-extensions-bundle.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'translogic_vc_extensions_merge_styles' ) ) {
	
	function translogic_vc_extensions_merge_styles($list) {
		$list[] = 'plugins/vc-extensions-bundle/vc-extensions-bundle.css';
		return $list;
	}
}


// Add VC specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'translogic_vc_extensions_get_css' ) ) {
	
	function translogic_vc_extensions_get_css($css, $colors, $fonts) {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

CSS;
		}
		
		return $css;
	}
}
?>