<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0.06
 */

$translogic_header_css = $translogic_header_image = '';
$translogic_header_video = wp_is_mobile() ? '' : translogic_get_theme_option('header_video');
if (true || empty($translogic_header_video)) {
	$translogic_header_image = get_header_image();
	if (translogic_is_on(translogic_get_theme_option('header_image_override')) && apply_filters('translogic_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($translogic_cat_img = translogic_get_category_image()) != '')
				$translogic_header_image = $translogic_cat_img;
		} else if (is_singular() || translogic_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$translogic_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($translogic_header_image)) $translogic_header_image = $translogic_header_image[0];
			} else
				$translogic_header_image = '';
		}
	}
}

$translogic_header_id = str_replace('header-custom-', '', translogic_get_theme_option("header_style"));
if ((int) $translogic_header_id == 0) {
	$translogic_header_id = translogic_get_post_id(array(
			'name' => $translogic_header_id,
			'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
		)
	);
} else {
	$translogic_header_id = apply_filters('trx_addons_filter_get_translated_layout', $translogic_header_id);
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($translogic_header_id);
						echo !empty($translogic_header_image) || !empty($translogic_header_video) ? ' with_bg_image' : ' without_bg_image';
						if ($translogic_header_video!='') echo ' with_bg_video';
						if ($translogic_header_image!='') echo ' '.esc_attr(translogic_add_inline_style('background-image: url('.esc_url($translogic_header_image).');'));
						if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
						if (translogic_is_on(translogic_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(translogic_is_inherit(translogic_get_theme_option('header_scheme')) 
														? translogic_get_theme_option('color_scheme') 
														: translogic_get_theme_option('header_scheme'));
						?>"><?php
		
	// Custom header's layout
	do_action('translogic_action_show_layout', $translogic_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	get_template_part( 'templates/header-single' );
		
?></header>