<?php
/**
 * The template to display "Header 1"
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_header_css = $translogic_header_image = '';
$translogic_header_video = wp_is_mobile() ? '' : translogic_get_theme_option('header_video');
if (true || empty($translogic_header_video)) {
	$translogic_header_image = get_header_image();
	if (translogic_is_on(translogic_get_theme_option('header_image_override')) && apply_filters('translogic_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($translogic_cat_img = translogic_get_category_image()) != '')
				$translogic_header_image = $translogic_cat_img;
		} else if (is_singular() || translogic_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$translogic_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($translogic_header_image)) $translogic_header_image = $translogic_header_image[0];
			} else
				$translogic_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
					echo !empty($translogic_header_image) || !empty($translogic_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($translogic_header_video!='') echo ' with_bg_video';
					if ($translogic_header_image!='') echo ' '.esc_attr(translogic_add_inline_style('background-image: url('.esc_url($translogic_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (translogic_is_on(translogic_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(translogic_is_inherit(translogic_get_theme_option('header_scheme')) 
													? translogic_get_theme_option('color_scheme') 
													: translogic_get_theme_option('header_scheme'));
					?>"><?php
	
	// Main menu
	if (translogic_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	

?></header>