<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_args = get_query_var('translogic_logo_args');
$translogic_inverse = isset($translogic_args['inverse']) ? $translogic_args['inverse'] : false;

// Site logo
$translogic_logo_image  = translogic_get_logo_image($translogic_inverse);
$translogic_logo_text   = get_bloginfo( 'name' );
$translogic_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($translogic_logo_image) || !empty($translogic_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($translogic_logo_image)) {
			$translogic_attr = translogic_getimagesize($translogic_logo_image);
			echo '<img src="'.esc_url($translogic_logo_image).'" alt="'. esc_attr(basename($translogic_logo_image)).'"'.(!empty($translogic_attr[3]) ? sprintf(' %s', $translogic_attr[3]) : '').'>' ;
		} else {
			translogic_show_layout(translogic_prepare_macros($translogic_logo_text), '<span class="logo_text">', '</span>');
			translogic_show_layout(translogic_prepare_macros($translogic_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>